/*
 * Decompiled with CFR 0.152.
 */
package com.zerodeplibs.webpush.jwt;

import com.zerodeplibs.webpush.jwt.VAPIDJWTCreationException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.util.Base64;

class JwtUtil {
    private static final int R_LENGTH = 32;
    private static final int VR_LENGTH_INDEX = 3;
    private static final int S_LENGTH = 32;
    private static final int MAX_PADDING_LENGTH = 1;

    JwtUtil() {
    }

    static String withSign(String header, String payload, ECPrivateKey privateKey) {
        byte[] headerBase64Bytes = JwtUtil.encodeString(header);
        byte[] payloadBase64Bytes = JwtUtil.encodeString(payload);
        byte[] message = new byte[headerBase64Bytes.length + payloadBase64Bytes.length + 1];
        System.arraycopy(headerBase64Bytes, 0, message, 0, headerBase64Bytes.length);
        message[headerBase64Bytes.length] = 46;
        System.arraycopy(payloadBase64Bytes, 0, message, headerBase64Bytes.length + 1, payloadBase64Bytes.length);
        try {
            byte[] signature = JwtUtil.signWith(message, privateKey);
            return String.format("%s.%s.%s", JwtUtil.asString(headerBase64Bytes), JwtUtil.asString(payloadBase64Bytes), JwtUtil.asString(signature));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw VAPIDJWTCreationException.withDefaultMessage(e);
        }
    }

    private static String asString(byte[] data) {
        return new String(data, StandardCharsets.UTF_8);
    }

    private static byte[] signWith(byte[] data, ECPrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature sig = Signature.getInstance("SHA256withECDSA");
        sig.initSign(privateKey);
        sig.update(data);
        return JwtUtil.encode(JwtUtil.toJws(sig.sign()));
    }

    static byte[] toJws(byte[] signature) {
        if (signature[0] != 48 || signature[2] != 2) {
            throw new VAPIDJWTCreationException("The format of the signature isn't valid DER");
        }
        byte vrLength = signature[3];
        if (33 < vrLength || signature[3 + vrLength + 1] != 2) {
            throw new VAPIDJWTCreationException(String.format("The format of the signature isn't valid DER. (vrLength = %d)", vrLength));
        }
        int vsLengthIndex = 3 + vrLength + 2;
        byte vsLength = signature[vsLengthIndex];
        if (33 < vsLength) {
            throw new VAPIDJWTCreationException(String.format("The format of the signature isn't valid DER. (vsLength = %d)", vsLength));
        }
        byte[] rs = new byte[64];
        int vrPadding = vrLength - 32;
        int vsPadding = vsLength - 32;
        System.arraycopy(signature, 4 + Math.max(0, vrPadding), rs, Math.max(0, -vrPadding), 32 - Math.max(0, -vrPadding));
        System.arraycopy(signature, vsLengthIndex + 1 + Math.max(0, vsPadding), rs, 32 + Math.max(0, -vsPadding), 32 - Math.max(0, -vsPadding));
        return rs;
    }

    private static byte[] encodeString(String data) {
        return JwtUtil.encode(data.getBytes(StandardCharsets.UTF_8));
    }

    private static byte[] encode(byte[] data) {
        return Base64.getUrlEncoder().withoutPadding().encode(data);
    }
}

