/*
 * Decompiled with CFR 0.152.
 */
package com.zerodeplibs.webpush;

import com.zerodeplibs.webpush.EncryptedPushMessage;
import java.nio.ByteBuffer;
import java.util.Arrays;

class Aes128GcmEncryptedMessage
implements EncryptedPushMessage {
    private final byte[] encryptedMessage;

    Aes128GcmEncryptedMessage(byte[] encryptedPayload) {
        this.encryptedMessage = encryptedPayload;
    }

    @Override
    public byte[] toBytes() {
        return Arrays.copyOf(this.encryptedMessage, this.encryptedMessage.length);
    }

    @Override
    public int length() {
        return this.encryptedMessage.length;
    }

    @Override
    public String contentEncoding() {
        return "aes128gcm";
    }

    byte[] extractSalt() {
        return Arrays.copyOfRange(this.encryptedMessage, 0, 16);
    }

    int extractRecordSize() {
        return ByteBuffer.wrap(this.encryptedMessage, 16, 4).getInt();
    }

    int extractKeyLength() {
        return this.encryptedMessage[20];
    }

    byte[] extractUncompressedAsPublicKeyBytes() {
        return Arrays.copyOfRange(this.encryptedMessage, 21, 21 + this.extractKeyLength());
    }

    byte[] extractContent() {
        return Arrays.copyOfRange(this.encryptedMessage, 21 + this.extractKeyLength(), this.encryptedMessage.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Aes128GcmEncryptedMessage)) {
            return false;
        }
        Aes128GcmEncryptedMessage that = (Aes128GcmEncryptedMessage)o;
        return Arrays.equals(this.encryptedMessage, that.encryptedMessage);
    }

    public int hashCode() {
        return Arrays.hashCode(this.encryptedMessage);
    }

    public String toString() {
        return "Aes128GcmEncryptedMessage{contentEncoding='" + this.contentEncoding() + "', length='" + this.length() + "', mediaType='" + this.mediaType() + "'}";
    }
}

