/*
 * Decompiled with CFR 0.152.
 */
package com.zenjava.javafx.maven.plugin;

import com.oracle.tools.packager.Bundler;
import com.oracle.tools.packager.Bundlers;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.zenjava.javafx.maven.plugin.AbstractJfxToolsMojo;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class NativeMojo
extends AbstractJfxToolsMojo {
    protected String identifier;
    protected String vendor;
    protected File nativeOutputDir;
    private String bundleType;
    private String bundler;
    private Map<String, String> jvmProperties;
    private List<String> jvmArgs;
    private Map<String, String> userJvmArgs;
    private String nativeReleaseVersion;
    protected boolean needShortcut;
    protected boolean needMenu;
    protected Map<String, String> bundleArguments;
    protected String appName;
    protected boolean jfxCallFromCLI;
    protected File additionalAppResources;
    protected boolean skipNativeLauncherWorkaround124;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.jfxCallFromCLI) {
            this.getLog().info((CharSequence)"call from CLI - skipping creation of Native Installers");
            return;
        }
        if ("NONE".equalsIgnoreCase(this.bundleType)) {
            return;
        }
        this.getLog().info((CharSequence)"Building Native Installers");
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(StandardBundlerParam.VERBOSE.getID(), this.verbose);
            if (this.identifier != null) {
                params.put(StandardBundlerParam.IDENTIFIER.getID(), this.identifier);
            }
            params.put(StandardBundlerParam.APP_NAME.getID(), this.appName);
            params.put(StandardBundlerParam.VERSION.getID(), this.nativeReleaseVersion);
            params.put(StandardBundlerParam.VENDOR.getID(), this.vendor);
            params.put(StandardBundlerParam.SHORTCUT_HINT.getID(), this.needShortcut);
            params.put(StandardBundlerParam.MENU_HINT.getID(), this.needMenu);
            params.put(StandardBundlerParam.MAIN_CLASS.getID(), this.mainClass);
            if (this.jvmProperties != null) {
                HashMap<String, String> jvmProps = new HashMap<String, String>();
                for (String key : this.jvmProperties.keySet()) {
                    jvmProps.put(key, this.jvmProperties.get(key));
                }
                params.put(StandardBundlerParam.JVM_PROPERTIES.getID(), jvmProps);
            }
            if (this.jvmArgs != null) {
                ArrayList<String> jvmOptions = new ArrayList<String>();
                for (String arg : this.jvmArgs) {
                    jvmOptions.add(arg);
                }
                params.put(StandardBundlerParam.JVM_OPTIONS.getID(), jvmOptions);
            }
            if (this.userJvmArgs != null) {
                HashMap<String, String> userJvmOptions = new HashMap<String, String>();
                for (String key : this.userJvmArgs.keySet()) {
                    userJvmOptions.put(key, this.userJvmArgs.get(key));
                }
                params.put(StandardBundlerParam.USER_JVM_OPTIONS.getID(), userJvmOptions);
            }
            HashSet resourceFiles = new HashSet();
            if (this.additionalAppResources != null && this.additionalAppResources.exists()) {
                try {
                    final Path targetFolder = this.jfxAppOutputDir.toPath();
                    final Path sourceFolder = this.additionalAppResources.toPath();
                    Files.walkFileTree(this.additionalAppResources.toPath(), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path subfolder, BasicFileAttributes attrs) throws IOException {
                            Files.createDirectories(targetFolder.resolve(sourceFolder.relativize(subfolder)), new FileAttribute[0]);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path sourceFile, BasicFileAttributes attrs) throws IOException {
                            Files.copy(sourceFile, targetFolder.resolve(sourceFolder.relativize(sourceFile)), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path source, IOException ioe) throws IOException {
                            NativeMojo.this.getLog().warn((CharSequence)String.format("Couldn't copy additional app resource %s with reason %s", source.toString(), ioe.getLocalizedMessage()));
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path source, IOException ioe) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                Files.walk(this.jfxAppOutputDir.toPath(), new FileVisitOption[0]).forEach(p -> {
                    File f = p.toFile();
                    if (f.isFile()) {
                        this.getLog().info((CharSequence)String.format("Add %s file to application resources.", p.toFile()));
                        resourceFiles.add(p.toFile());
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            params.put(StandardBundlerParam.APP_RESOURCES.getID(), new RelativeFileSet(this.jfxAppOutputDir, resourceFiles));
            if (this.bundleArguments == null) {
                this.bundleArguments = new HashMap<String, String>();
            }
            HashSet duplicateKeys = new HashSet(params.keySet());
            duplicateKeys.retainAll(this.bundleArguments.keySet());
            if (!duplicateKeys.isEmpty()) {
                throw new MojoExecutionException("The following keys in <bundleArguments> duplicate other settings, please remove one or the other: " + ((Object)duplicateKeys).toString());
            }
            params.putAll(this.bundleArguments);
            Bundlers bundlers = Bundlers.createBundlersInstance();
            boolean foundBundler = false;
            for (Bundler b : bundlers.getBundlers()) {
                try {
                    if (this.bundleType != null && !"ALL".equalsIgnoreCase(this.bundleType) && !b.getBundleType().equalsIgnoreCase(this.bundleType) || this.bundler != null && !"ALL".equalsIgnoreCase(this.bundler) && !this.bundler.equalsIgnoreCase(b.getID())) continue;
                    foundBundler = true;
                    if (!b.validate(params)) continue;
                    b.execute(params, this.nativeOutputDir);
                    if (!this.isJavaVersion(8) || !this.isAtLeastOracleJavaUpdateVersion(40) || !"linux.app".equals(b.getID())) continue;
                    boolean needsWorkaround = this.appName.contains(".");
                    if (!this.skipNativeLauncherWorkaround124 && needsWorkaround) {
                        this.getLog().info((CharSequence)"Applying workaround for oracle-jdk-bug since 1.8.0u40");
                        String newConfigFileName = this.appName.substring(0, this.appName.lastIndexOf("."));
                        Path oldConfigFile = this.nativeOutputDir.toPath().resolve(this.appName).resolve("app").resolve(this.appName + ".cfg");
                        try {
                            Files.move(oldConfigFile, this.nativeOutputDir.toPath().resolve(this.appName).resolve("app").resolve(newConfigFileName + ".cfg"), StandardCopyOption.ATOMIC_MOVE);
                        }
                        catch (IOException ex) {
                            this.getLog().warn((CharSequence)"Couldn't rename configfile. Please see issue #124 of the javafx-maven-plugin for further details.", (Throwable)ex);
                        }
                        continue;
                    }
                    this.getLog().info((CharSequence)"Skipped workaround for native linux launcher.");
                }
                catch (UnsupportedPlatformException needsWorkaround) {
                }
                catch (ConfigException e) {
                    this.getLog().info((CharSequence)("Skipping " + b.getName() + " because of configuration error " + e.getMessage() + "\nAdvice to Fix: " + e.getAdvice()));
                }
            }
            if (!foundBundler) {
                this.getLog().warn((CharSequence)("No bundler found for given type " + this.bundleType + ". Please check your configuration."));
            }
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException("An error occurred while generating native deployment bundles", (Exception)e);
        }
    }
}

