/*
 * Decompiled with CFR 0.152.
 */
package com.zengularity.benji.s3;

import akka.NotUsed;
import akka.NotUsed$;
import akka.stream.Materializer;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.zengularity.benji.Compat$;
import com.zengularity.benji.URIProvider;
import com.zengularity.benji.package;
import com.zengularity.benji.s3.PathStyleWSRequestBuilder;
import com.zengularity.benji.s3.SignatureCalculatorV1;
import com.zengularity.benji.s3.SignatureCalculatorV4;
import com.zengularity.benji.s3.SignatureCalculatorV4$;
import com.zengularity.benji.s3.VirtualHostWSRequestBuilder;
import com.zengularity.benji.s3.WSRequestBuilder;
import com.zengularity.benji.s3.WSS3;
import com.zengularity.benji.s3.WSS3$;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import play.api.libs.ws.StandaloneWSRequest;
import play.api.libs.ws.StandaloneWSResponse;
import play.api.libs.ws.ahc.AhcWSClientConfig;
import play.api.libs.ws.ahc.AhcWSClientConfig$;
import play.api.libs.ws.ahc.StandaloneAhcWSClient;
import play.api.libs.ws.ahc.StandaloneAhcWSClient$;
import play.shaded.ahc.io.netty.handler.codec.http.QueryStringDecoder;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.matching.Regex;
import scala.xml.Elem;
import scala.xml.XML$;

public final class S3$ {
    public static S3$ MODULE$;
    private Regex HttpUrl;
    private volatile boolean bitmap$0;

    static {
        new S3$();
    }

    public WSS3 apply(String accessKeyId, String secretAccessKeyId, String scheme, String host, StandaloneAhcWSClient ws) {
        return new WSS3(ws, new PathStyleWSRequestBuilder(new SignatureCalculatorV1(accessKeyId, secretAccessKeyId, host), new URL(new java.lang.StringBuilder(3).append(scheme).append("://").append(host).toString())), WSS3$.MODULE$.$lessinit$greater$default$3());
    }

    public WSS3 virtualHost(String accessKeyId, String secretAccessKeyId, String scheme, String host, StandaloneAhcWSClient ws) {
        return new WSS3(ws, new VirtualHostWSRequestBuilder(new SignatureCalculatorV1(accessKeyId, secretAccessKeyId, host), new URL(new java.lang.StringBuilder(3).append(scheme).append("://").append(host).toString())), WSS3$.MODULE$.$lessinit$greater$default$3());
    }

    public WSS3 virtualHostAwsV4(String accessKeyId, String secretAccessKeyId, String scheme, String host, String region, StandaloneAhcWSClient ws) {
        return new WSS3(ws, new VirtualHostWSRequestBuilder(new SignatureCalculatorV4(accessKeyId, secretAccessKeyId, region, SignatureCalculatorV4$.MODULE$.$lessinit$greater$default$4()), new URL(new java.lang.StringBuilder(3).append(scheme).append("://").append(host).toString())), WSS3$.MODULE$.$lessinit$greater$default$3());
    }

    public <T> Try<WSS3> apply(T config, StandaloneAhcWSClient ws, URIProvider<T> provider) {
        return provider.apply(config).flatMap((Function1 & Serializable & scala.Serializable)builtUri -> {
            Failure failure;
            if (builtUri == null) {
                failure = new Failure((Throwable)new IllegalArgumentException("URI provider returned a null URI"));
            } else {
                String string = builtUri.getScheme();
                String string2 = "s3";
                if (string == null ? string2 != null : !string.equals(string2)) {
                    failure = new Failure((Throwable)new IllegalArgumentException("Expected URI with scheme containing \"s3:\""));
                } else {
                    Failure failure2;
                    String string3 = builtUri.getSchemeSpecificPart();
                    Option option = MODULE$.HttpUrl().unapplySeq((CharSequence)string3);
                    if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(4) == 0) {
                        String scheme = (String)((LinearSeqOptimized)option.get()).apply(0);
                        String accessKey = (String)((LinearSeqOptimized)option.get()).apply(1);
                        String secret = (String)((LinearSeqOptimized)option.get()).apply(2);
                        String raw = (String)((LinearSeqOptimized)option.get()).apply(3);
                        failure2 = this.fromUri$1(new URI(new java.lang.StringBuilder(3).append(scheme).append("://").append(raw).toString()), accessKey, secret, ws);
                    } else {
                        failure2 = new Failure((Throwable)new IllegalArgumentException(new java.lang.StringBuilder(49).append("Expected URI containing accessKey and secretKey: ").append(string3).toString()));
                    }
                    failure = failure2;
                }
            }
            return failure;
        });
    }

    public WSS3 apply(WSRequestBuilder requestBuilder, StandaloneAhcWSClient ws) {
        return new WSS3(ws, requestBuilder, WSS3$.MODULE$.$lessinit$greater$default$3());
    }

    public StandaloneAhcWSClient client(AhcWSClientConfig config, Materializer materializer) {
        return StandaloneAhcWSClient$.MODULE$.apply(config, StandaloneAhcWSClient$.MODULE$.apply$default$2(), materializer);
    }

    public AhcWSClientConfig client$default$1() {
        return new AhcWSClientConfig(AhcWSClientConfig$.MODULE$.apply$default$1(), AhcWSClientConfig$.MODULE$.apply$default$2(), AhcWSClientConfig$.MODULE$.apply$default$3(), AhcWSClientConfig$.MODULE$.apply$default$4(), AhcWSClientConfig$.MODULE$.apply$default$5(), AhcWSClientConfig$.MODULE$.apply$default$6(), AhcWSClientConfig$.MODULE$.apply$default$7(), AhcWSClientConfig$.MODULE$.apply$default$8(), AhcWSClientConfig$.MODULE$.apply$default$9(), AhcWSClientConfig$.MODULE$.apply$default$10(), AhcWSClientConfig$.MODULE$.apply$default$11());
    }

    public <T> Source<T, NotUsed> getXml(Function0<StandaloneWSRequest> req, Function1<Elem, Source<T, NotUsed>> f, Function1<StandaloneWSResponse, Throwable> err, Materializer m) {
        return (Source)Source$.MODULE$.fromFuture(((StandaloneWSRequest)req.apply()).withMethod("GET").stream().flatMap((Function1 & Serializable & scala.Serializable)response -> response.status() == 200 || response.status() == 206 ? Future$.MODULE$.successful((Object)response.bodyAsSource().mapMaterializedValue((Function1 & Serializable & scala.Serializable)x$2 -> NotUsed$.MODULE$).fold((Object)new StringBuilder(), (Function2 & Serializable & scala.Serializable)(x$3, x$4) -> x$3.$plus$plus$eq(x$4.utf8String())).flatMapConcat((Function1 & Serializable & scala.Serializable)buf -> (Source)f.apply((Object)XML$.MODULE$.loadString(buf.result())))) : Future$.MODULE$.failed((Throwable)err.apply(response)), S3$.ec$1(m))).flatMapConcat((Function1 & Serializable & scala.Serializable)x -> (Source)Predef$.MODULE$.identity(x));
    }

    private Map<String, Seq<String>> parseQuery(URI uri) {
        return Compat$.MODULE$.mapValues(((TraversableOnce)Compat$.MODULE$.javaConverters().mapAsScalaMapConverter(new QueryStringDecoder(uri.toString()).parameters()).asScala()).toMap(Predef$.MODULE$.$conforms()), (Function1 & Serializable & scala.Serializable)x$5 -> ((SeqLike)Compat$.MODULE$.javaConverters().asScalaBufferConverter(x$5).asScala()).toSeq());
    }

    private Regex HttpUrl$lzycompute() {
        S3$ s3$ = this;
        synchronized (s3$) {
            if (!this.bitmap$0) {
                this.HttpUrl = new StringOps(Predef$.MODULE$.augmentString("^(http[s]*)://([^:]+):([^@]+)@(.+)$")).r();
                this.bitmap$0 = true;
            }
        }
        return this.HttpUrl;
    }

    private Regex HttpUrl() {
        return !this.bitmap$0 ? this.HttpUrl$lzycompute() : this.HttpUrl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Try reqTimeout$1(Map params$1) {
        Seq seq;
        Some some;
        boolean bl = false;
        Some some2 = null;
        Option option = params$1.get((Object)"requestTimeout");
        if (option instanceof Some) {
            String string;
            Option option2;
            bl = true;
            some2 = (Some)option;
            Seq seq2 = (Seq)some2.value();
            Some some3 = Seq$.MODULE$.unapplySeq(seq2);
            if (!some3.isEmpty() && some3.get() != null && ((SeqLike)some3.get()).lengthCompare(1) == 0 && !(option2 = package.LongVal$.MODULE$.unapply(string = (String)((SeqLike)some3.get()).apply(0))).isEmpty()) {
                long timeout = BoxesRunTime.unboxToLong((Object)option2.get());
                return new Success((Object)new Some((Object)BoxesRunTime.boxToLong((long)timeout)));
            }
        }
        if (bl && !(some = Seq$.MODULE$.unapplySeq(seq = (Seq)some2.value())).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
            String v = (String)((SeqLike)some.get()).apply(0);
            return new Failure((Throwable)new IllegalArgumentException(new java.lang.StringBuilder(42).append("Invalid request timeout parameter in URI: ").append(v).toString()));
        }
        if (!bl) return new Success((Object)Option$.MODULE$.empty());
        Seq ps = (Seq)some2.value();
        return new Failure((Throwable)new IllegalArgumentException(new java.lang.StringBuilder(42).append("Invalid request timeout parameter in URI: ").append(ps.toString()).toString()));
    }

    private static final Option awsRegion$1(Map params$1) {
        return params$1.get((Object)"awsRegion").collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Seq<String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Some some = Seq$.MODULE$.unapplySeq(A1);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                    String region = (String)((SeqLike)some.get()).apply(0);
                    object = region;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Seq<String> x1) {
                Seq<String> seq = x1;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                boolean bl = !some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0;
                return bl;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Try storage$1(Map params$1, String accessKey$1, String secretKey$1, String scheme$1, String host$1, StandaloneAhcWSClient ws$1) {
        String string;
        Seq seq;
        Some some;
        String string2;
        Seq seq2;
        Some some2;
        boolean bl = false;
        Some some3 = null;
        Option option = params$1.get((Object)"style");
        if (option instanceof Some) {
            String string3;
            bl = true;
            some3 = (Some)option;
            Seq seq3 = (Seq)some3.value();
            Some some4 = Seq$.MODULE$.unapplySeq(seq3);
            if (!some4.isEmpty() && some4.get() != null && ((SeqLike)some4.get()).lengthCompare(1) == 0 && "path".equals(string3 = (String)((SeqLike)some4.get()).apply(0)) && S3$.awsRegion$1(params$1).isDefined()) {
                return new Failure((Throwable)new IllegalArgumentException("Style 'virtualHost' must be specified when 'awsRegion' is defined"));
            }
        }
        if (bl && !(some2 = Seq$.MODULE$.unapplySeq(seq2 = (Seq)some3.value())).isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0 && "virtualHost".equals(string2 = (String)((SeqLike)some2.get()).apply(0))) {
            Success success;
            Option option2 = S3$.awsRegion$1(params$1);
            if (option2 instanceof Some) {
                Some some5 = (Some)option2;
                String region = (String)some5.value();
                success = new Success((Object)this.virtualHostAwsV4(accessKey$1, secretKey$1, scheme$1, host$1, region, ws$1));
                return success;
            } else {
                success = new Success((Object)this.virtualHost(accessKey$1, secretKey$1, scheme$1, host$1, ws$1));
            }
            return success;
        }
        if (bl && !(some = Seq$.MODULE$.unapplySeq(seq = (Seq)some3.value())).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && "path".equals(string = (String)((SeqLike)some.get()).apply(0))) {
            return new Success((Object)this.apply(accessKey$1, secretKey$1, scheme$1, host$1, ws$1));
        }
        if (!bl) return new Failure((Throwable)new IllegalArgumentException("Expected style parameter in URI"));
        Seq style = (Seq)some3.value();
        return new Failure((Throwable)new IllegalArgumentException(new java.lang.StringBuilder(32).append("Invalid style parameter in URI: ").append(style.toString()).toString()));
    }

    private final Try fromUri$1(URI uri, String accessKey, String secretKey, StandaloneAhcWSClient ws$1) {
        String host = uri.getHost();
        String scheme = uri.getScheme();
        Map<String, Seq<String>> params = this.parseQuery(uri);
        return S3$.reqTimeout$1(params).flatMap((Function1 & Serializable & scala.Serializable)timeout -> this.storage$1(params, accessKey, secretKey, scheme, host, ws$1).map((Function1 & Serializable & scala.Serializable)s3 -> (WSS3)timeout.fold((Function0 & Serializable & scala.Serializable)() -> s3, (Function1 & Serializable & scala.Serializable)x$1 -> s3.withRequestTimeout(BoxesRunTime.unboxToLong((Object)x$1)))));
    }

    private static final ExecutionContext ec$1(Materializer m$1) {
        return m$1.executionContext();
    }

    private S3$() {
        MODULE$ = this;
    }
}

