/*
 * Decompiled with CFR 0.152.
 */
package com.zengularity.benji.s3;

import com.zengularity.benji.exception.BenjiUnknownError;
import com.zengularity.benji.exception.BenjiUnknownError$;
import com.zengularity.benji.exception.BucketAlreadyExistsException;
import com.zengularity.benji.exception.BucketNotEmptyException;
import com.zengularity.benji.exception.BucketNotFoundException;
import com.zengularity.benji.exception.ObjectNotFoundException;
import com.zengularity.benji.exception.VersionNotFoundException;
import com.zengularity.benji.s3.WSS3BucketRef;
import com.zengularity.benji.s3.WSS3ObjectRef;
import com.zengularity.benji.s3.WSS3VersionedObjectRef;
import play.api.libs.ws.StandaloneWSResponse;
import scala.Function0;
import scala.runtime.BoxesRunTime;

public final class ErrorHandler$ {
    public static ErrorHandler$ MODULE$;

    static {
        new ErrorHandler$();
    }

    /*
     * Enabled aggressive block sorting
     */
    public Throwable ofBucket(Function0<String> defaultMessage, String bucketName, StandaloneWSResponse response) {
        BenjiUnknownError benjiUnknownError;
        int n = response.status();
        switch (n) {
            case 404: {
                if (!response.body().contains("<Code>NoSuchBucket</Code>")) break;
                benjiUnknownError = new BucketNotFoundException(bucketName);
                return benjiUnknownError;
            }
            case 409: {
                if (response.body().contains("<Code>BucketAlreadyOwnedByYou</Code>")) {
                    benjiUnknownError = new BucketAlreadyExistsException(bucketName);
                    return benjiUnknownError;
                }
                if (!response.body().contains("<Code>BucketNotEmpty</Code>")) break;
                benjiUnknownError = new BucketNotEmptyException(bucketName);
                return benjiUnknownError;
            }
        }
        benjiUnknownError = new BenjiUnknownError(new StringBuilder(16).append(defaultMessage.apply()).append(" - Response: ").append(((Object)BoxesRunTime.boxToInteger((int)n)).toString()).append(" - ").append(response.body()).toString(), BenjiUnknownError$.MODULE$.apply$default$2());
        return benjiUnknownError;
    }

    public Throwable ofBucket(Function0<String> defaultMessage, WSS3BucketRef bucket, StandaloneWSResponse response) {
        return this.ofBucket(defaultMessage, bucket.name(), response);
    }

    public Throwable ofObject(Function0<String> defaultMessage, String bucketName, String objName, StandaloneWSResponse response) {
        BenjiUnknownError benjiUnknownError;
        int n = response.status();
        switch (n) {
            case 404: {
                if (response.body().contains("<Code>NoSuchBucket</Code>") || response.body().contains("<Code>NoSuchKey</Code>") || response.body().isEmpty()) {
                    benjiUnknownError = new ObjectNotFoundException(bucketName, objName);
                    break;
                }
            }
            default: {
                benjiUnknownError = new BenjiUnknownError(new StringBuilder(16).append(defaultMessage.apply()).append(" - Response: ").append(((Object)BoxesRunTime.boxToInteger((int)n)).toString()).append(" - ").append(response.body()).toString(), BenjiUnknownError$.MODULE$.apply$default$2());
                break;
            }
        }
        return benjiUnknownError;
    }

    public Throwable ofObject(Function0<String> defaultMessage, WSS3ObjectRef obj, StandaloneWSResponse response) {
        return this.ofObject(defaultMessage, obj.bucket(), obj.name(), response);
    }

    public Throwable ofVersion(Function0<String> defaultMessage, String bucketName, String objName, String versionId, StandaloneWSResponse response) {
        BenjiUnknownError benjiUnknownError;
        int n = response.status();
        switch (n) {
            case 404: {
                if (response.body().contains("<Code>NoSuchBucket</Code>") || response.body().contains("<Code>NoSuchKey</Code>") || response.body().contains("<Code>NoSuchVersion</Code>") || response.body().isEmpty()) {
                    benjiUnknownError = new VersionNotFoundException(bucketName, objName, versionId);
                    break;
                }
            }
            default: {
                benjiUnknownError = new BenjiUnknownError(new StringBuilder(16).append(defaultMessage.apply()).append(" - Response: ").append(((Object)BoxesRunTime.boxToInteger((int)n)).toString()).append(" - ").append(response.body()).toString(), BenjiUnknownError$.MODULE$.apply$default$2());
                break;
            }
        }
        return benjiUnknownError;
    }

    public Throwable ofVersion(Function0<String> defaultMessage, WSS3VersionedObjectRef version, StandaloneWSResponse response) {
        return this.ofVersion(defaultMessage, version.bucket(), version.name(), version.versionId(), response);
    }

    private ErrorHandler$() {
        MODULE$ = this;
    }
}

