/*
 * Decompiled with CFR 0.152.
 */
package com.zengcanxiang.baseAdapter.recyclerView;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zengcanxiang.baseAdapter.interFace.OnItemClickListener;
import com.zengcanxiang.baseAdapter.recyclerView.BaseViewHolder;
import java.util.List;

public abstract class BaseAdapter<T>
extends RecyclerView.Adapter<BaseViewHolder> {
    protected List<T> mList;
    protected Context mContext;
    protected LayoutInflater mLInflater;
    protected int[] mLayoutId;
    protected ViewGroup mParent;
    protected OnItemClickListener mOnItemClickListener;

    public OnItemClickListener getOnItemClickListener() {
        return this.mOnItemClickListener;
    }

    public void setOnItemClickListener(OnItemClickListener<T> listener) {
        this.mOnItemClickListener = listener;
    }

    public BaseAdapter(@NonNull List<T> data, Context context, int ... layoutId) {
        this.mList = data;
        this.mLayoutId = layoutId;
        this.mContext = context;
        this.mLInflater = LayoutInflater.from((Context)this.mContext);
    }

    public int getItemViewType(int position) {
        return this.checkLayoutIndex(this.mList.get(position), position);
    }

    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType < 0 || viewType > this.mLayoutId.length) {
            throw new ArrayIndexOutOfBoundsException("checkLayoutIndex > LayoutId.length \uff1a" + viewType + ">" + this.mLayoutId.length);
        }
        if (this.mLayoutId.length == 0) {
            throw new IllegalArgumentException("not layoutId");
        }
        this.mParent = parent;
        int layoutId = this.mLayoutId[viewType];
        View view = this.inflaterView(layoutId);
        BaseViewHolder viewHolder = (BaseViewHolder)((Object)view.getTag());
        if (viewHolder == null || viewHolder.getLayoutId() != layoutId) {
            viewHolder = new BaseViewHolder(this.mContext, layoutId, view);
        }
        if (this.mOnItemClickListener != null) {
            final BaseViewHolder finalViewHolder = viewHolder;
            viewHolder.getItemView().setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int position = finalViewHolder.getAdapterPosition();
                    BaseAdapter.this.mOnItemClickListener.onItemClick(finalViewHolder, position -= BaseAdapter.this.getHeadSize(), BaseAdapter.this.mList.get(position));
                }
            });
        }
        return viewHolder;
    }

    public final void onBindViewHolder(BaseViewHolder holder, int position) {
        this.onBindViewHolder(holder, position, null);
    }

    public final void onBindViewHolder(BaseViewHolder holder, int position, List<Object> payloads) {
        T item = this.mList.get(position);
        if (payloads == null || payloads.isEmpty()) {
            this.bindData(holder, position, item);
        } else {
            this.bindData(holder, position, item, payloads);
        }
    }

    protected void bindData(BaseViewHolder viewHolder, int position, T item, List<Object> payloads) {
    }

    public int getItemCount() {
        return this.mList == null ? 0 : this.mList.size();
    }

    protected abstract void bindData(BaseViewHolder var1, int var2, T var3);

    public int checkLayoutIndex(T item, int position) {
        return 0;
    }

    public View inflaterView(@LayoutRes int layoutId) {
        return this.mLInflater.inflate(layoutId, this.mParent, false);
    }

    public ViewGroup getParent() {
        return this.mParent;
    }

    protected void setListener(BaseViewHolder viewHolder, int position, T item) {
    }

    public int getHeadSize() {
        return 0;
    }
}

