/*
 * Decompiled with CFR 0.152.
 */
package com.zengcanxiang.baseAdapter.recyclerView;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zengcanxiang.baseAdapter.R;
import java.util.List;

public class HeadFootAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private final int ID_HEAD = 1;
    private final int ID_FOOTER = 2;
    private final int VIEW_TYPE_HEAD = 1;
    private final int VIEW_TYPE_FOOTER = 2;
    private View mHeadView;
    private View mFootView;
    private RecyclerView.Adapter mDataAdapter;
    private RecyclerView.LayoutManager mLayoutManager;
    private boolean isStaggered;

    public HeadFootAdapter(RecyclerView.Adapter dataAdapter) {
        this.mDataAdapter = dataAdapter;
        RecyclerView.AdapterDataObserver mDataObserver = new RecyclerView.AdapterDataObserver(){

            public void onChanged() {
                HeadFootAdapter.this.notifyDataSetChanged();
            }

            public void onItemRangeChanged(int positionStart, int itemCount) {
                HeadFootAdapter.this.notifyItemRangeChanged(HeadFootAdapter.this.data2HeadPosition(positionStart), itemCount);
            }

            public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
                HeadFootAdapter.this.notifyItemRangeChanged(HeadFootAdapter.this.data2HeadPosition(positionStart), itemCount, payload);
            }

            public void onItemRangeInserted(int positionStart, int itemCount) {
                HeadFootAdapter.this.notifyItemRangeInserted(HeadFootAdapter.this.data2HeadPosition(positionStart), itemCount);
            }

            public void onItemRangeRemoved(int positionStart, int itemCount) {
                HeadFootAdapter.this.notifyItemRangeRemoved(HeadFootAdapter.this.data2HeadPosition(positionStart), itemCount);
            }

            public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
                HeadFootAdapter.this.notifyItemRangeChanged(HeadFootAdapter.this.data2HeadPosition(fromPosition), HeadFootAdapter.this.data2HeadPosition(toPosition) + itemCount);
            }
        };
        this.mDataAdapter.registerAdapterDataObserver(mDataObserver);
        this.setHasStableIds(this.mDataAdapter.hasStableIds());
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        if (this.mHeadView != null && this.mHeadView.getParent() != null) {
            ((ViewGroup)this.mHeadView.getParent()).removeView(this.mHeadView);
        }
        if (this.mFootView != null && this.mFootView.getParent() != null) {
            ((ViewGroup)this.mFootView.getParent()).removeView(this.mFootView);
        }
        this.mLayoutManager = recyclerView.getLayoutManager();
        this.initLayoutManager();
    }

    private void initLayoutManager() {
        if (this.mLayoutManager instanceof GridLayoutManager) {
            final GridLayoutManager castedLayoutManager = (GridLayoutManager)this.mLayoutManager;
            final GridLayoutManager.SpanSizeLookup existingLookup = castedLayoutManager.getSpanSizeLookup();
            castedLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    if (HeadFootAdapter.this.isHeader(position) || HeadFootAdapter.this.isFooter(position)) {
                        return castedLayoutManager.getSpanCount();
                    }
                    return existingLookup.getSpanSize(HeadFootAdapter.this.head2DataPosition(position));
                }
            });
        } else if (this.mLayoutManager instanceof StaggeredGridLayoutManager) {
            this.isStaggered = true;
        }
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 1 || viewType == 2) {
            return new HeadFooterViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.base_head_footer_adapter_item, parent, false));
        }
        return this.mDataAdapter.onCreateViewHolder(parent, viewType);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof HeadFooterViewHolder) {
            this.bind((HeadFooterViewHolder)holder, position);
        } else {
            this.mDataAdapter.onBindViewHolder(holder, this.head2DataPosition(position));
        }
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position, List<Object> payloads) {
        if (holder instanceof HeadFooterViewHolder) {
            this.bind((HeadFooterViewHolder)holder, position);
        } else {
            this.mDataAdapter.onBindViewHolder(holder, this.head2DataPosition(position), payloads);
        }
    }

    private void bind(HeadFooterViewHolder holder, int position) {
        StaggeredGridLayoutManager.LayoutParams layoutParams;
        View viewToAdd = this.isHeader(position) ? this.mHeadView : this.mFootView;
        ViewGroup itemView = (ViewGroup)holder.itemView;
        if (itemView != null) {
            itemView.removeAllViews();
            itemView.addView(viewToAdd);
        }
        if (this.isStaggered) {
            layoutParams = viewToAdd.getLayoutParams() == null ? new StaggeredGridLayoutManager.LayoutParams(-1, -2) : new StaggeredGridLayoutManager.LayoutParams(viewToAdd.getLayoutParams().width, viewToAdd.getLayoutParams().height);
            layoutParams.setFullSpan(true);
        } else {
            layoutParams = viewToAdd.getLayoutParams() == null ? new ViewGroup.LayoutParams(-1, -2) : new ViewGroup.LayoutParams(viewToAdd.getLayoutParams().width, viewToAdd.getLayoutParams().height);
        }
        holder.itemView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public int getItemCount() {
        int itemCount = this.mDataAdapter.getItemCount();
        if (this.hasHeadView()) {
            ++itemCount;
        }
        if (this.hasFootView()) {
            ++itemCount;
        }
        return itemCount;
    }

    public long getItemId(int position) {
        if (this.isHeader(position)) {
            return 1L;
        }
        if (this.isFooter(position)) {
            return 2L;
        }
        return this.mDataAdapter.getItemId(position);
    }

    public int getItemViewType(int position) {
        if (this.isHeader(position)) {
            return 1;
        }
        if (this.isFooter(position)) {
            return 2;
        }
        return this.mDataAdapter.getItemViewType(this.head2DataPosition(position));
    }

    public int data2HeadPosition(int position) {
        return position + (this.hasHeadView() ? 1 : 0);
    }

    private int head2DataPosition(int position) {
        return position - (this.hasHeadView() ? 1 : 0);
    }

    private int getFootPosition() {
        return this.mDataAdapter.getItemCount() + (this.hasHeadView() ? 1 : 0);
    }

    public int getFootViewPosition() {
        if (this.hasFootView()) {
            return this.getFootPosition();
        }
        return -1;
    }

    public int getHeadViewPosition() {
        return this.hasHeadView() ? 0 : -1;
    }

    private boolean isHeader(int position) {
        return this.hasHeadView() && position == 0;
    }

    private boolean isFooter(int position) {
        return this.hasFootView() && position == this.getFootPosition();
    }

    public boolean hasHeadView() {
        return this.getHeadView() != null;
    }

    public boolean hasFootView() {
        return this.getFootView() != null;
    }

    public View getHeadView() {
        return this.mHeadView;
    }

    public void addHeadView(@Nullable View headView) {
        boolean hadHeader;
        if (this.mHeadView == headView) {
            return;
        }
        boolean bl = hadHeader = this.mHeadView != null;
        if (hadHeader) {
            this.detachFromParent(this.mHeadView);
        }
        this.mHeadView = headView;
        if (headView == null) {
            if (hadHeader) {
                this.notifyItemRemoved(0);
            }
        } else if (hadHeader) {
            this.notifyItemChanged(0);
        } else {
            this.notifyItemInserted(0);
        }
    }

    public void removeHeadView() {
        this.addHeadView(null);
    }

    public View getFootView() {
        return this.mFootView;
    }

    public void addFootView(@Nullable View footView) {
        boolean hadFooter;
        if (this.mFootView == footView) {
            return;
        }
        boolean bl = hadFooter = this.mFootView != null;
        if (hadFooter) {
            this.detachFromParent(this.mFootView);
        }
        this.mFootView = footView;
        if (footView == null) {
            if (hadFooter) {
                this.notifyItemRemoved(this.getFootPosition());
            }
        } else if (hadFooter) {
            this.notifyItemChanged(this.getFootPosition());
        } else {
            this.notifyItemInserted(this.getFootPosition());
        }
    }

    public void removeFootView() {
        this.addFootView(null);
    }

    private void detachFromParent(@NonNull View view) {
        ViewGroup parent = (ViewGroup)view.getParent();
        if (parent != null) {
            parent.removeView(view);
        }
    }

    private class HeadFooterViewHolder
    extends RecyclerView.ViewHolder {
        HeadFooterViewHolder(View itemView) {
            super(itemView);
        }
    }
}

