/*
 * Decompiled with CFR 0.152.
 */
package com.zengcanxiang.baseAdapter.expandableListView;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import com.zengcanxiang.baseAdapter.absListView.BaseViewHolder;
import com.zengcanxiang.baseAdapter.absListView.HelperViewHolder;
import java.util.List;

public abstract class BaseAdapter<T>
extends BaseExpandableListAdapter {
    protected List<List<T>> mList;
    protected Context mContext;
    private LayoutInflater mLInflater;
    private int[] groupLayoutIds;
    private int[] childLayoutIds;
    private BaseViewHolder holder = new HelperViewHolder();

    public BaseAdapter(@Nullable List<List<T>> data, Context context, @NonNull @LayoutRes int[] groupLayoutIds, int ... childLayoutIds) {
        this.mList = data;
        this.groupLayoutIds = groupLayoutIds;
        this.childLayoutIds = childLayoutIds;
        this.mContext = context;
        this.mLInflater = LayoutInflater.from((Context)this.mContext);
    }

    public final int getGroupCount() {
        return this.mList.size();
    }

    public final int getChildrenCount(int groupPosition) {
        return this.mList.get(groupPosition).size();
    }

    public final Object getGroup(int groupPosition) {
        return this.mList.get(groupPosition);
    }

    public final Object getChild(int groupPosition, int childPosition) {
        return this.mList.get(groupPosition).get(childPosition);
    }

    public final long getGroupId(int groupPosition) {
        return groupPosition;
    }

    public final long getChildId(int groupPosition, int childPosition) {
        return childPosition;
    }

    public boolean hasStableIds() {
        return true;
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return true;
    }

    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        if (this.groupLayoutIds == null || this.groupLayoutIds.length == 0) {
            throw new IllegalArgumentException("not groupLayoutId");
        }
        int groupLayoutId = this.groupLayoutIds[this.checkGroupLayoutIndex(groupPosition, this.mList.get(groupPosition))];
        this.holder = this.holder.get(this.mContext, groupPosition, convertView, parent, groupLayoutId);
        this.convertGroup(this.holder, groupPosition, this.mList.get(groupPosition));
        return this.holder.getConvertView(groupLayoutId);
    }

    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        if (this.childLayoutIds == null || this.childLayoutIds.length == 0) {
            throw new IllegalArgumentException("not childLayoutId");
        }
        int childLayoutId = this.childLayoutIds[this.checkChildLayoutIndex(childPosition, this.mList.get(groupPosition).get(childPosition))];
        this.holder = this.holder.get(this.mContext, childPosition, convertView, parent, childLayoutId);
        this.convertChild(this.holder, groupPosition, childPosition, this.mList.get(groupPosition).get(childPosition));
        return this.holder.getConvertView(childLayoutId);
    }

    public int checkChildLayoutIndex(int childPosition, T item) {
        return 0;
    }

    public int checkGroupLayoutIndex(int groupLosition, List<T> childs) {
        return 0;
    }

    public abstract <BH extends BaseViewHolder> void convertGroup(BH var1, int var2, List<T> var3);

    public abstract <BH extends BaseViewHolder> void convertChild(BH var1, int var2, int var3, T var4);
}

