/*
 * Decompiled with CFR 0.152.
 */
package com.zengcanxiang.baseAdapter.expandableListView;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import com.zengcanxiang.baseAdapter.absListView.BaseViewHolder;
import com.zengcanxiang.baseAdapter.absListView.HelperViewHolder;
import java.util.List;

public abstract class BaseAdapter2<G, C>
extends BaseExpandableListAdapter {
    protected List<List<C>> mChildData;
    protected List<G> mGroupData;
    protected Context mContext;
    private LayoutInflater mLInflater;
    private int[] groupLayoutIds;
    private int[] childLayoutIds;
    private BaseViewHolder holder = new HelperViewHolder();

    public BaseAdapter2(@Nullable List<G> groupData, List<List<C>> childData, Context context, @NonNull @LayoutRes int[] groupLayoutIds, int ... childLayoutIds) {
        this.mChildData = childData;
        this.mGroupData = groupData;
        this.groupLayoutIds = groupLayoutIds;
        this.childLayoutIds = childLayoutIds;
        this.mContext = context;
        this.mLInflater = LayoutInflater.from((Context)this.mContext);
    }

    public final int getGroupCount() {
        return this.mGroupData.size();
    }

    public final int getChildrenCount(int groupPosition) {
        return this.mChildData.get(groupPosition).size();
    }

    public final Object getGroup(int groupPosition) {
        return this.mGroupData.get(groupPosition);
    }

    public final Object getChild(int groupPosition, int childPosition) {
        return this.mChildData.get(groupPosition).get(childPosition);
    }

    public final long getGroupId(int groupPosition) {
        return groupPosition;
    }

    public final long getChildId(int groupPosition, int childPosition) {
        return childPosition;
    }

    public boolean hasStableIds() {
        return true;
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return true;
    }

    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        if (this.groupLayoutIds == null || this.groupLayoutIds.length == 0) {
            throw new IllegalArgumentException("not groupLayoutId");
        }
        int groupLayoutId = this.groupLayoutIds[this.checkGroupLayoutIndex(groupPosition, this.mGroupData.get(groupPosition), this.mChildData.get(groupPosition))];
        this.holder = this.holder.get(this.mContext, groupPosition, convertView, parent, groupLayoutId);
        this.convertGroup(this.holder, groupPosition, this.mGroupData.get(groupPosition), this.mChildData.get(groupPosition));
        return this.holder.getConvertView(groupLayoutId);
    }

    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        if (this.childLayoutIds == null || this.childLayoutIds.length == 0) {
            throw new IllegalArgumentException("not childLayoutId");
        }
        int childLayoutId = this.childLayoutIds[this.checkChildLayoutIndex(childPosition, this.mChildData.get(groupPosition).get(childPosition))];
        this.holder = this.holder.get(this.mContext, childPosition, convertView, parent, childLayoutId);
        this.convertChild(this.holder, groupPosition, childPosition, this.mChildData.get(groupPosition).get(childPosition));
        return this.holder.getConvertView(childLayoutId);
    }

    public int checkChildLayoutIndex(int childPosition, C item) {
        return 0;
    }

    public int checkGroupLayoutIndex(int groupLosition, G item, List<C> childs) {
        return 0;
    }

    public abstract <BH extends BaseViewHolder> void convertGroup(BH var1, int var2, G var3, List<C> var4);

    public abstract <BH extends BaseViewHolder> void convertChild(BH var1, int var2, int var3, C var4);
}

