/*
 * Decompiled with CFR 0.152.
 */
package com.zengcanxiang.baseAdapter.absListView;

import android.content.Context;
import com.zengcanxiang.baseAdapter.absListView.BaseAdapter;
import com.zengcanxiang.baseAdapter.absListView.BaseViewHolder;
import com.zengcanxiang.baseAdapter.absListView.HelperViewHolder;
import com.zengcanxiang.baseAdapter.interFace.DataHelper;
import java.util.ArrayList;
import java.util.List;

public abstract class HelperAdapter<T>
extends BaseAdapter<T>
implements DataHelper<T> {
    public HelperAdapter(List<T> mList, Context context, int ... layoutIds) {
        super(mList, context, layoutIds);
    }

    @Deprecated
    public HelperAdapter(List<T> mList, Context context) {
        super(mList, context);
    }

    @Override
    public <BH extends BaseViewHolder> void convert(BH viewHolder, int position, T t) {
        HelperViewHolder holder = (HelperViewHolder)viewHolder;
        this.HelpConvert(holder, position, t);
    }

    public abstract void HelpConvert(HelperViewHolder var1, int var2, T var3);

    @Override
    public boolean isEnabled() {
        if (this.mList == null) {
            return false;
        }
        return this.mList.size() > 0;
    }

    @Override
    public void addItemToHead(T data) {
        this.add(0, data);
    }

    @Override
    public boolean addItemToLast(T data) {
        if (!this.isEnabled()) {
            this.addItemToHead(data);
            return true;
        }
        boolean result = this.mList.add(data);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public boolean addItemsToHead(List<T> datas) {
        return this.addAll(0, datas);
    }

    @Override
    public boolean addItemsToLast(List<T> datas) {
        if (!this.isEnabled()) {
            this.addItemsToHead(datas);
        }
        return this.addAll(this.mList.size() - 1, datas);
    }

    @Override
    public boolean addAll(int startPosition, List<T> datas) {
        this.initList();
        boolean result = this.mList.addAll(startPosition < 0 ? 0 : startPosition, datas);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public void add(int startPosition, T data) {
        this.initList();
        this.mList.add(startPosition, data);
        this.notifyDataSetChanged();
    }

    @Override
    public T getData(int index) {
        return this.getCount() == 0 ? null : (T)this.mList.get(index);
    }

    @Override
    public void alterObj(T oldData, T newData) {
        this.alterObj(this.mList.indexOf(oldData), newData);
    }

    @Override
    public void alterObj(int index, T data) {
        this.initList();
        this.mList.set(index, data);
        this.notifyDataSetChanged();
    }

    @Override
    public boolean remove(T data) {
        if (this.mList == null) {
            throw new IllegalArgumentException("list is null,cannot execute");
        }
        boolean result = this.mList.remove(data);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public void removeToIndex(int index) {
        if (this.mList == null) {
            throw new IllegalArgumentException("list is null,cannot execute");
        }
        this.mList.remove(index);
        this.notifyDataSetChanged();
    }

    @Override
    public void replaceAll(List<T> data) {
        this.initList();
        this.mList.clear();
        this.addAll(0, data);
    }

    @Override
    public void clear() {
        this.initList();
        this.mList.clear();
        this.notifyDataSetChanged();
    }

    @Override
    public boolean contains(T data) {
        this.initList();
        return this.mList.contains(data);
    }

    private void initList() {
        if (this.mList == null) {
            this.mList = new ArrayList();
        }
    }
}

