/*
 * Decompiled with CFR 0.152.
 */
package com.zengcanxiang.baseAdapter.expandableListView;

import android.content.Context;
import com.zengcanxiang.baseAdapter.absListView.BaseViewHolder;
import com.zengcanxiang.baseAdapter.absListView.HelperViewHolder;
import com.zengcanxiang.baseAdapter.expandableListView.BaseAdapter2;
import java.util.ArrayList;
import java.util.List;

public abstract class HelperAdapter2<G, C>
extends BaseAdapter2<G, C> {
    public HelperAdapter2(List<G> groupData, List<List<C>> childData, Context context, int[] groupLayoutIds, int ... childLayoutIds) {
        super(groupData, childData, context, groupLayoutIds, childLayoutIds);
    }

    @Override
    public <BH extends BaseViewHolder> void convertGroup(BH viewHolder, int groupPosition, G item, List<C> childs) {
        HelperViewHolder holder = (HelperViewHolder)viewHolder;
        this.HelpConvertGroup(holder, groupPosition, item, childs);
    }

    @Override
    public <BH extends BaseViewHolder> void convertChild(BH viewHolder, int groupPosition, int childPosition, C t) {
        HelperViewHolder holder = (HelperViewHolder)viewHolder;
        this.HelpConvertChild(holder, groupPosition, childPosition, t);
    }

    public abstract void HelpConvertGroup(HelperViewHolder var1, int var2, G var3, List<C> var4);

    public abstract void HelpConvertChild(HelperViewHolder var1, int var2, int var3, C var4);

    public boolean isGroupEnabled() {
        if (this.mGroupData == null) {
            return false;
        }
        return this.mGroupData.size() > 0;
    }

    public boolean isChildEnabled() {
        if (this.mChildData == null) {
            return false;
        }
        return this.mChildData.size() > 0;
    }

    public boolean isChildEnabledToGroupIndex(int groupIndex) {
        if (this.isChildEnabled()) {
            if (this.mChildData.get(groupIndex) == null) {
                return false;
            }
            return ((List)this.mChildData.get(groupIndex)).size() > 0;
        }
        return false;
    }

    public boolean addAllGroup(int startPosition, List<G> groups, List<List<C>> childs) {
        this.initListGroup();
        this.initListChild();
        boolean groupResult = this.mGroupData.addAll(startPosition < 0 ? 0 : startPosition, groups);
        boolean childResult = this.mChildData.addAll(startPosition < 0 ? 0 : startPosition, childs);
        if (groupResult && childResult) {
            this.notifyDataSetChanged();
        } else {
            this.mGroupData.removeAll(groups);
            this.mChildData.removeAll(childs);
        }
        return groupResult && childResult;
    }

    public boolean addAllChild(int startPosition, int groupIndex, List<C> childs) {
        this.initListChild();
        this.initListGroup();
        boolean result = ((List)this.mChildData.get(groupIndex)).addAll(startPosition < 0 ? 0 : startPosition, childs);
        this.notifyDataSetChanged();
        return result;
    }

    public boolean addAGroupToHead(G group, List<C> childs) {
        return this.addAGroup(0, group, childs);
    }

    public boolean addAChildToHead(int groupIndex, C child) {
        return this.addChilds(0, groupIndex, child);
    }

    public boolean addAGroupToLast(G group, List<C> childs) {
        return this.addAGroup(this.mGroupData.size() - 1, group, childs);
    }

    public boolean addChildToLast(int groupIndex, C child) {
        return this.addChilds(((List)this.mChildData.get(groupIndex)).size() - 1, groupIndex, child);
    }

    public boolean addAGroup(int startPosition, G group, List<C> childs) {
        ArrayList<List<C>> tempChild = new ArrayList<List<C>>();
        tempChild.add(childs);
        ArrayList<G> tempGroup = new ArrayList<G>();
        tempGroup.add(group);
        return this.addAllGroup(startPosition, tempGroup, tempChild);
    }

    public boolean addChilds(int startPosition, int groupIndex, C child) {
        ArrayList<C> tempChild = new ArrayList<C>();
        tempChild.add(child);
        return this.addAllChild(startPosition, groupIndex, tempChild);
    }

    public void remove(List<G> groups, List<List<C>> childs) {
        this.initListGroup();
        this.initListChild();
        this.mGroupData.removeAll(groups);
        this.mChildData.removeAll(childs);
        this.notifyDataSetChanged();
    }

    public void removeAGroupToIndex(int removePosition) {
        this.initListGroup();
        this.initListChild();
        this.mGroupData.remove(removePosition);
        this.mChildData.remove(removePosition);
        this.notifyDataSetChanged();
    }

    public void removeAGroup(G removeGroup, List<C> removeChild) {
        this.initListGroup();
        this.initListChild();
        this.mGroupData.remove(removeGroup);
        this.mChildData.remove(removeChild);
        this.notifyDataSetChanged();
    }

    public void removeAChild(int groupIndex, int removePosition) {
        this.initListGroup();
        this.initListChild();
        ((List)this.mChildData.get(groupIndex)).remove(removePosition);
        this.notifyDataSetChanged();
    }

    public boolean removeAChild(int groupIndex, C removeData) {
        this.throwException();
        boolean result = ((List)this.mChildData.get(groupIndex)).remove(removeData);
        this.notifyDataSetChanged();
        return result;
    }

    public void alterAGroup(int startPosition, G aGroup, List<C> childs) {
        this.throwException();
        this.mGroupData.set(startPosition, aGroup);
        this.mChildData.set(startPosition, childs);
        this.notifyDataSetChanged();
    }

    public void alterAChild(int startPosition, int groupIndex, C child) {
        this.throwException();
        ((List)this.mChildData.get(groupIndex)).set(startPosition, child);
        this.notifyDataSetChanged();
    }

    public boolean containsAGroup(G group, List<C> childs) {
        this.initListChild();
        this.initListGroup();
        return this.mGroupData.contains(group) && this.mChildData.contains(childs);
    }

    public boolean containsAGroup(G group) {
        this.initListGroup();
        return this.mGroupData.contains(group);
    }

    public boolean containsAChilds(int groupIndex, C child) {
        this.throwException();
        return ((List)this.mChildData.get(groupIndex)).contains(child);
    }

    public void replaceAll(List<G> groups, List<List<C>> childs) {
        this.initListGroup();
        this.initListChild();
        this.mGroupData.clear();
        this.mChildData.clear();
        this.addAllGroup(0, groups, childs);
    }

    public void clear() {
        this.initListGroup();
        this.initListChild();
        this.mGroupData.clear();
        this.mChildData.clear();
        this.notifyDataSetChanged();
    }

    private void initListGroup() {
        if (this.mGroupData == null) {
            this.mGroupData = new ArrayList();
        }
    }

    private void initListChild() {
        if (this.mChildData == null) {
            this.mChildData = new ArrayList();
        }
    }

    private void throwException() {
        if (this.mGroupData == null) {
            throw new IllegalArgumentException("mGroupData is null,cannot execute");
        }
        if (this.mChildData == null) {
            throw new IllegalArgumentException("mChildData is null,cannot execute");
        }
    }
}

