/*
 * Decompiled with CFR 0.152.
 */
package com.zengcanxiang.baseAdapter.absListView;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.util.Linkify;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.Checkable;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.TextView;
import com.zengcanxiang.baseAdapter.absListView.BaseViewHolder;

public class HelperHolder
extends BaseViewHolder {
    public HelperHolder(Context context, int position, ViewGroup parent, int layoutId) {
        super(context, position, parent, layoutId);
    }

    public HelperHolder() {
    }

    @Override
    public HelperHolder get(Context context, int position, View convertView, ViewGroup parent, int layoutId) {
        if (convertView == null) {
            return new HelperHolder(context, position, parent, layoutId);
        }
        HelperHolder bHolder = (HelperHolder)convertView.getTag();
        if (bHolder.getLayoutId() != layoutId) {
            return new HelperHolder(context, position, parent, layoutId);
        }
        bHolder.setPosition(position);
        return bHolder;
    }

    public HelperHolder setText(int viewId, String value) {
        TextView view = (TextView)this.getView(viewId);
        view.setText((CharSequence)value);
        return this;
    }

    public HelperHolder setImageResource(int viewId, int imageResId) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageResource(imageResId);
        return this;
    }

    public HelperHolder setBackgroundColor(int viewId, int color) {
        Object view = this.getView(viewId);
        view.setBackgroundColor(color);
        return this;
    }

    public HelperHolder setBackgroundRes(int viewId, int backgroundRes) {
        Object view = this.getView(viewId);
        view.setBackgroundResource(backgroundRes);
        return this;
    }

    public HelperHolder setTextColor(int viewId, int textColor) {
        TextView view = (TextView)this.getView(viewId);
        view.setTextColor(textColor);
        return this;
    }

    public HelperHolder setTextColorRes(int viewId, int textColorRes) {
        TextView view = (TextView)this.getView(viewId);
        view.setTextColor(this.mContext.getResources().getColor(textColorRes));
        return this;
    }

    public HelperHolder setImageDrawable(int viewId, Drawable drawable) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageDrawable(drawable);
        return this;
    }

    public HelperHolder setImageUrl(int viewId, String imageUrl) {
        ImageView view = (ImageView)this.getView(viewId);
        return this;
    }

    public HelperHolder setImageBitmap(int viewId, Bitmap bitmap) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageBitmap(bitmap);
        return this;
    }

    public HelperHolder setVisible(int viewId, boolean visible) {
        Object view = this.getView(viewId);
        view.setVisibility(visible ? 0 : 8);
        return this;
    }

    public HelperHolder setTag(int viewId, Object tag) {
        Object view = this.getView(viewId);
        view.setTag(tag);
        return this;
    }

    public HelperHolder setTag(int viewId, int key, Object tag) {
        Object view = this.getView(viewId);
        view.setTag(key, tag);
        return this;
    }

    public HelperHolder setChecked(int viewId, boolean checked) {
        Checkable view = (Checkable)this.getView(viewId);
        view.setChecked(checked);
        return this;
    }

    public HelperHolder setAdapter(int viewId, Adapter adapter) {
        AdapterView view = (AdapterView)this.getView(viewId);
        view.setAdapter(adapter);
        return this;
    }

    @SuppressLint(value={"NewApi"})
    public HelperHolder setAlpha(int viewId, float value) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.getView(viewId).setAlpha(value);
        } else {
            AlphaAnimation alpha = new AlphaAnimation(value, value);
            alpha.setDuration(0L);
            alpha.setFillAfter(true);
            this.getView(viewId).startAnimation((Animation)alpha);
        }
        return this;
    }

    public HelperHolder linkify(int viewId) {
        TextView view = (TextView)this.getView(viewId);
        Linkify.addLinks((TextView)view, (int)15);
        return this;
    }

    public HelperHolder setTypeface(int viewId, Typeface typeface) {
        TextView view = (TextView)this.getView(viewId);
        view.setTypeface(typeface);
        view.setPaintFlags(view.getPaintFlags() | 0x80);
        return this;
    }

    public HelperHolder setTypeface(Typeface typeface, int ... viewIds) {
        for (int viewId : viewIds) {
            TextView view = (TextView)this.getView(viewId);
            view.setTypeface(typeface);
            view.setPaintFlags(view.getPaintFlags() | 0x80);
        }
        return this;
    }

    public HelperHolder setProgress(int viewId, int progress) {
        ProgressBar view = (ProgressBar)this.getView(viewId);
        view.setProgress(progress);
        return this;
    }

    public HelperHolder setProgress(int viewId, int progress, int max) {
        ProgressBar view = (ProgressBar)this.getView(viewId);
        view.setMax(max);
        view.setProgress(progress);
        return this;
    }

    public HelperHolder setMax(int viewId, int max) {
        ProgressBar view = (ProgressBar)this.getView(viewId);
        view.setMax(max);
        return this;
    }

    public HelperHolder setRating(int viewId, float rating) {
        RatingBar view = (RatingBar)this.getView(viewId);
        view.setRating(rating);
        return this;
    }

    public HelperHolder setRating(int viewId, float rating, int max) {
        RatingBar view = (RatingBar)this.getView(viewId);
        view.setMax(max);
        view.setRating(rating);
        return this;
    }
}

