/*
 * Decompiled with CFR 0.152.
 */
package com.zengcanxiang.baseAdapter.absListView;

import android.content.Context;
import com.zengcanxiang.baseAdapter.absListView.BaseAdapter;
import java.util.List;

public abstract class HelperAdapter<T>
extends BaseAdapter<T> {
    public HelperAdapter(List<T> mList, Context context, int ... layoutIds) {
        super(mList, context, layoutIds);
    }

    @Deprecated
    public HelperAdapter(List<T> mList, Context context) {
        super(mList, context);
    }

    public boolean isEnabled(int position) {
        return position < this.mList.size();
    }

    public void add(int startPosition, T data) {
        this.mList.add(startPosition, data);
        this.notifyDataSetChanged();
    }

    public void addItemToLast(T data) {
        this.mList.add(data);
        this.notifyDataSetChanged();
    }

    public void addItemToHead(T item) {
        this.add(0, item);
    }

    public void addItemsToHead(List<T> items) {
        this.addAll(0, items);
    }

    public void addAll(int startPosition, List<T> data) {
        this.mList.addAll(startPosition, data);
        this.notifyDataSetChanged();
    }

    public void set(T oldData, T newData) {
        this.set(this.mList.indexOf(oldData), newData);
    }

    public void set(int index, T data) {
        this.mList.set(index, data);
        this.notifyDataSetChanged();
    }

    public void remove(T data) {
        this.mList.remove(data);
        this.notifyDataSetChanged();
    }

    public void removeToIndex(int index) {
        this.mList.remove(index);
        this.notifyDataSetChanged();
    }

    public void replaceAll(List<T> data) {
        this.mList.clear();
        this.addAll(0, data);
    }

    public boolean contains(T data) {
        return this.mList.contains(data);
    }

    public void clear() {
        this.mList.clear();
        this.notifyDataSetChanged();
    }
}

