/*
 * Decompiled with CFR 0.152.
 */
package com.zengcanxiang.baseAdapter.absListView;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zengcanxiang.baseAdapter.absListView.HelperHolder;
import java.util.List;

public abstract class BaseAdapter<T>
extends android.widget.BaseAdapter {
    protected List<T> mList;
    protected Context mContext;
    protected LayoutInflater mLInflater;
    protected int[] layoutIds;
    private HelperHolder holder = new HelperHolder();

    public BaseAdapter(List<T> data, Context context, int ... layoutIds) {
        this.mList = data;
        this.layoutIds = layoutIds;
        this.mContext = context;
        this.mLInflater = LayoutInflater.from((Context)this.mContext);
    }

    public BaseAdapter(List<T> data, Context context) {
        this.mList = data;
        this.mContext = context;
        this.mLInflater = LayoutInflater.from((Context)this.mContext);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        int layoutId = this.getViewCheckLayoutId(position);
        this.holder = this.holder.get(this.mContext, position, convertView, parent, layoutId);
        this.convert(this.holder, position, this.mList.get(position));
        return this.holder.getConvertView(layoutId);
    }

    protected int getViewCheckLayoutId(int position) {
        int layoutId;
        if (this.layoutIds == null) {
            layoutId = this.checkLayoutId(position, this.mList.get(position));
        } else {
            if (this.layoutIds.length == 0) {
                throw new ArrayIndexOutOfBoundsException("not layoutId");
            }
            layoutId = this.layoutIds[this.checkLayout(position, this.mList.get(position))];
        }
        return layoutId;
    }

    public abstract void convert(HelperHolder var1, int var2, T var3);

    public int checkLayout(int position, T item) {
        return 0;
    }

    public int checkLayoutId(int position, T item) {
        return 0;
    }

    public int getCount() {
        return this.mList == null ? 0 : this.mList.size();
    }

    public Object getItem(int position) {
        return this.mList.get(position);
    }

    public long getItemId(int position) {
        return position;
    }
}

