/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.event;

import com.github.shyiko.mysql.binlog.event.EventData;
import com.github.shyiko.mysql.binlog.event.MySqlGtid;

public class GtidEventData
implements EventData {
    public static final byte COMMIT_FLAG = 1;
    private MySqlGtid gtid;
    private byte flags;
    private long lastCommitted;
    private long sequenceNumber;
    private long immediateCommitTimestamp;
    private long originalCommitTimestamp;
    private long transactionLength;
    private int immediateServerVersion;
    private int originalServerVersion;

    @Deprecated
    public GtidEventData() {
    }

    public GtidEventData(MySqlGtid gtid, byte flags, long lastCommitted, long sequenceNumber, long immediateCommitTimestamp, long originalCommitTimestamp, long transactionLength, int immediateServerVersion, int originalServerVersion) {
        this.gtid = gtid;
        this.flags = flags;
        this.lastCommitted = lastCommitted;
        this.sequenceNumber = sequenceNumber;
        this.immediateCommitTimestamp = immediateCommitTimestamp;
        this.originalCommitTimestamp = originalCommitTimestamp;
        this.transactionLength = transactionLength;
        this.immediateServerVersion = immediateServerVersion;
        this.originalServerVersion = originalServerVersion;
    }

    @Deprecated
    public String getGtid() {
        return this.gtid.toString();
    }

    @Deprecated
    public void setGtid(String gtid) {
        this.gtid = MySqlGtid.fromString(gtid);
    }

    public MySqlGtid getMySqlGtid() {
        return this.gtid;
    }

    public byte getFlags() {
        return this.flags;
    }

    public long getLastCommitted() {
        return this.lastCommitted;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getImmediateCommitTimestamp() {
        return this.immediateCommitTimestamp;
    }

    public long getOriginalCommitTimestamp() {
        return this.originalCommitTimestamp;
    }

    public long getTransactionLength() {
        return this.transactionLength;
    }

    public int getImmediateServerVersion() {
        return this.immediateServerVersion;
    }

    public int getOriginalServerVersion() {
        return this.originalServerVersion;
    }

    @Deprecated
    public void setFlags(byte flags) {
        this.flags = flags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GtidEventData");
        sb.append("{flags=").append(this.flags).append(", gtid='").append(this.gtid).append('\'');
        sb.append(", last_committed='").append(this.lastCommitted).append('\'');
        sb.append(", sequence_number='").append(this.sequenceNumber).append('\'');
        if (this.immediateCommitTimestamp != 0L) {
            sb.append(", immediate_commit_timestamp='").append(this.immediateCommitTimestamp).append('\'');
            sb.append(", original_commit_timestamp='").append(this.originalCommitTimestamp).append('\'');
        }
        if (this.transactionLength != 0L) {
            sb.append(", transaction_length='").append(this.transactionLength).append('\'');
            if (this.immediateServerVersion != 0) {
                sb.append(", immediate_server_version='").append(this.immediateServerVersion).append('\'');
                sb.append(", original_server_version='").append(this.originalServerVersion).append('\'');
            }
        }
        sb.append('}');
        return sb.toString();
    }
}

