/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog;

import com.github.shyiko.mysql.binlog.GtidSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class MariadbGtidSet
extends GtidSet {
    protected Map<Long, MariaGtid> positionMap = new HashMap<Long, MariaGtid>();
    protected Map<Long, LinkedHashMap<Long, MariaGtid>> seenMap = new LinkedHashMap<Long, LinkedHashMap<Long, MariaGtid>>();
    static String threeDashes = "\\d{1,10}-\\d{1,10}-\\d{1,20}";
    static Pattern MARIA_GTID_PATTERN = Pattern.compile("^" + threeDashes + "(\\s*,\\s*" + threeDashes + ")*$");

    public MariadbGtidSet() {
        super(null);
    }

    public MariadbGtidSet(String gtidSet) {
        super(null);
        if (gtidSet != null && gtidSet.length() > 0) {
            String[] gtids;
            for (String gtid : gtids = gtidSet.replaceAll("\n", "").split(",")) {
                MariaGtid mariaGtid = MariaGtid.parse(gtid);
                this.positionMap.put(mariaGtid.getDomainId(), mariaGtid);
                this.addToSeenSet(mariaGtid);
            }
        }
    }

    public static boolean isMariaGtidSet(String gtidSet) {
        return MARIA_GTID_PATTERN.matcher(gtidSet).find();
    }

    private void addToSeenSet(MariaGtid gtid) {
        if (!this.seenMap.containsKey(gtid.domainId)) {
            this.seenMap.put(gtid.domainId, new LinkedHashMap());
        }
        LinkedHashMap<Long, MariaGtid> domainMap = this.seenMap.get(gtid.domainId);
        domainMap.put(gtid.serverId, gtid);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (MariaGtid gtid : this.positionMap.values()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(gtid.toString());
        }
        return sb.toString();
    }

    @Override
    public String toSeenString() {
        StringBuilder sb = new StringBuilder();
        for (Long domainID : this.seenMap.keySet()) {
            for (MariaGtid gtid : this.seenMap.get(domainID).values()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(gtid.toString());
            }
        }
        return sb.toString();
    }

    @Override
    public Collection<GtidSet.UUIDSet> getUUIDSets() {
        throw new UnsupportedOperationException("Mariadb gtid not support this method");
    }

    @Override
    public GtidSet.UUIDSet getUUIDSet(String uuid) {
        throw new UnsupportedOperationException("Mariadb gtid not support this method");
    }

    @Override
    public GtidSet.UUIDSet putUUIDSet(GtidSet.UUIDSet uuidSet) {
        throw new UnsupportedOperationException("Mariadb gtid not support this method");
    }

    @Override
    public boolean add(String gtid) {
        MariaGtid mariaGtid = MariaGtid.parse(gtid);
        this.add(mariaGtid);
        return true;
    }

    public void add(MariaGtid gtid) {
        this.positionMap.put(gtid.getDomainId(), gtid);
        this.addToSeenSet(gtid);
    }

    @Override
    public boolean isContainedWithin(GtidSet other) {
        if (!(other instanceof MariadbGtidSet)) {
            return false;
        }
        MariadbGtidSet o = (MariadbGtidSet)other;
        for (Long domainID : this.seenMap.keySet()) {
            if (!o.seenMap.containsKey(domainID)) {
                return false;
            }
            LinkedHashMap<Long, MariaGtid> thisDomainMap = this.seenMap.get(domainID);
            LinkedHashMap<Long, MariaGtid> otherDomainMap = o.seenMap.get(domainID);
            for (Long serverID : thisDomainMap.keySet()) {
                if (!otherDomainMap.containsKey(serverID)) {
                    return false;
                }
                MariaGtid thisGtid = thisDomainMap.get(serverID);
                MariaGtid otherGtid = otherDomainMap.get(serverID);
                if (thisGtid.sequence <= otherGtid.sequence) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.seenMap.keySet().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MariadbGtidSet) {
            MariadbGtidSet that = (MariadbGtidSet)obj;
            return this.positionMap.equals(that.positionMap);
        }
        return false;
    }

    public static class MariaGtid {
        private long domainId;
        private long serverId;
        private long sequence;

        public MariaGtid(long domainId, long serverId, long sequence) {
            this.domainId = domainId;
            this.serverId = serverId;
            this.sequence = sequence;
        }

        public MariaGtid(String gtid) {
            String[] gtidArr = gtid.split("-");
            this.domainId = Long.parseLong(gtidArr[0]);
            this.serverId = Long.parseLong(gtidArr[1]);
            this.sequence = Long.parseLong(gtidArr[2]);
        }

        public static MariaGtid parse(String gtid) {
            return new MariaGtid(gtid);
        }

        public long getDomainId() {
            return this.domainId;
        }

        public void setDomainId(long domainId) {
            this.domainId = domainId;
        }

        public long getServerId() {
            return this.serverId;
        }

        public void setServerId(long serverId) {
            this.serverId = serverId;
        }

        public long getSequence() {
            return this.sequence;
        }

        public void setSequence(long sequence) {
            this.sequence = sequence;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MariaGtid mariaGtid = (MariaGtid)o;
            return this.domainId == mariaGtid.domainId && this.serverId == mariaGtid.serverId && this.sequence == mariaGtid.sequence;
        }

        public String toString() {
            return String.format("%s-%s-%s", this.domainId, this.serverId, this.sequence);
        }
    }
}

