/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.event.deserialization;

import com.github.shyiko.mysql.binlog.event.TableMapEventMetadata;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TableMapEventMetadataDeserializer {
    public TableMapEventMetadata deserialize(ByteArrayInputStream inputStream, int nIntColumns) throws IOException {
        int remainingBytes = inputStream.available();
        if (remainingBytes <= 0) {
            return null;
        }
        TableMapEventMetadata result = new TableMapEventMetadata();
        while (remainingBytes > 0) {
            MetadataFieldType fieldType = MetadataFieldType.byCode(inputStream.readInteger(1));
            int fieldLength = inputStream.readPackedInteger();
            remainingBytes = inputStream.available();
            inputStream.enterBlock(fieldLength);
            switch (fieldType) {
                case SIGNEDNESS: {
                    result.setSignedness(TableMapEventMetadataDeserializer.readSignedness(inputStream, nIntColumns));
                    break;
                }
                case DEFAULT_CHARSET: {
                    result.setDefaultCharset(TableMapEventMetadataDeserializer.readDefaultCharset(inputStream));
                    break;
                }
                case COLUMN_CHARSET: {
                    result.setColumnCharsets(TableMapEventMetadataDeserializer.readIntegers(inputStream));
                    break;
                }
                case COLUMN_NAME: {
                    result.setColumnNames(TableMapEventMetadataDeserializer.readColumnNames(inputStream));
                    break;
                }
                case SET_STR_VALUE: {
                    result.setSetStrValues(TableMapEventMetadataDeserializer.readTypeValues(inputStream));
                    break;
                }
                case ENUM_STR_VALUE: {
                    result.setEnumStrValues(TableMapEventMetadataDeserializer.readTypeValues(inputStream));
                    break;
                }
                case GEOMETRY_TYPE: {
                    result.setGeometryTypes(TableMapEventMetadataDeserializer.readIntegers(inputStream));
                    break;
                }
                case SIMPLE_PRIMARY_KEY: {
                    result.setSimplePrimaryKeys(TableMapEventMetadataDeserializer.readIntegers(inputStream));
                    break;
                }
                case PRIMARY_KEY_WITH_PREFIX: {
                    result.setPrimaryKeysWithPrefix(TableMapEventMetadataDeserializer.readIntegerPairs(inputStream));
                    break;
                }
                case ENUM_AND_SET_DEFAULT_CHARSET: {
                    result.setEnumAndSetDefaultCharset(TableMapEventMetadataDeserializer.readDefaultCharset(inputStream));
                    break;
                }
                case ENUM_AND_SET_COLUMN_CHARSET: {
                    result.setEnumAndSetColumnCharsets(TableMapEventMetadataDeserializer.readIntegers(inputStream));
                    break;
                }
                default: {
                    inputStream.enterBlock(remainingBytes);
                    throw new IOException("Unsupported table metadata field type " + fieldType);
                }
            }
            inputStream.enterBlock(remainingBytes -= fieldLength);
        }
        return result;
    }

    private static BitSet readSignedness(ByteArrayInputStream inputStream, int length) throws IOException {
        BitSet result = new BitSet();
        byte[] bytes = inputStream.read(length + 7 >> 3);
        for (int i = 0; i < length; ++i) {
            if ((bytes[i >> 3] & 1 << 7 - i % 8) == 0) continue;
            result.set(i);
        }
        return result;
    }

    private static TableMapEventMetadata.DefaultCharset readDefaultCharset(ByteArrayInputStream inputStream) throws IOException {
        TableMapEventMetadata.DefaultCharset result = new TableMapEventMetadata.DefaultCharset();
        result.setDefaultCharsetCollation(inputStream.readPackedInteger());
        Map<Integer, Integer> charsetCollations = TableMapEventMetadataDeserializer.readIntegerPairs(inputStream);
        if (!charsetCollations.isEmpty()) {
            result.setCharsetCollations(charsetCollations);
        }
        return result;
    }

    private static List<Integer> readIntegers(ByteArrayInputStream inputStream) throws IOException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (inputStream.available() > 0) {
            result.add(inputStream.readPackedInteger());
        }
        return result;
    }

    private static List<String> readColumnNames(ByteArrayInputStream inputStream) throws IOException {
        ArrayList<String> columnNames = new ArrayList<String>();
        while (inputStream.available() > 0) {
            columnNames.add(inputStream.readLengthEncodedString());
        }
        return columnNames;
    }

    private static List<String[]> readTypeValues(ByteArrayInputStream inputStream) throws IOException {
        ArrayList<String[]> result = new ArrayList<String[]>();
        while (inputStream.available() > 0) {
            ArrayList<String> typeValues = new ArrayList<String>();
            int valuesCount = inputStream.readPackedInteger();
            for (int i = 0; i < valuesCount; ++i) {
                typeValues.add(inputStream.readLengthEncodedString());
            }
            result.add(typeValues.toArray(new String[typeValues.size()]));
        }
        return result;
    }

    private static Map<Integer, Integer> readIntegerPairs(ByteArrayInputStream inputStream) throws IOException {
        LinkedHashMap<Integer, Integer> result = new LinkedHashMap<Integer, Integer>();
        while (inputStream.available() > 0) {
            int columnIndex = inputStream.readPackedInteger();
            int columnCharset = inputStream.readPackedInteger();
            result.put(columnIndex, columnCharset);
        }
        return result;
    }

    private static enum MetadataFieldType {
        SIGNEDNESS(1),
        DEFAULT_CHARSET(2),
        COLUMN_CHARSET(3),
        COLUMN_NAME(4),
        SET_STR_VALUE(5),
        ENUM_STR_VALUE(6),
        GEOMETRY_TYPE(7),
        SIMPLE_PRIMARY_KEY(8),
        PRIMARY_KEY_WITH_PREFIX(9),
        ENUM_AND_SET_DEFAULT_CHARSET(10),
        ENUM_AND_SET_COLUMN_CHARSET(11);

        private final int code;
        private static final Map<Integer, MetadataFieldType> INDEX_BY_CODE;

        private MetadataFieldType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static MetadataFieldType byCode(int code) {
            return INDEX_BY_CODE.get(code);
        }

        static {
            INDEX_BY_CODE = new HashMap<Integer, MetadataFieldType>();
            for (MetadataFieldType fieldType : MetadataFieldType.values()) {
                INDEX_BY_CODE.put(fieldType.code, fieldType);
            }
        }
    }
}

