/*
 * Decompiled with CFR 0.152.
 */
package com.app.progresviews;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import com.app.progreswheelview.R;
import java.text.DecimalFormat;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010-\u001a\u00020.H\u0002J\u001a\u0010/\u001a\u00020.2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u00100\u001a\u00020.2\u0006\u00101\u001a\u000202H\u0014J(\u00103\u001a\u00020.2\u0006\u00104\u001a\u00020\t2\u0006\u00105\u001a\u00020\t2\u0006\u00106\u001a\u00020\t2\u0006\u00107\u001a\u00020\tH\u0014J\u000e\u00108\u001a\u00020.2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u00109\u001a\u00020.2\u0006\u0010:\u001a\u00020\tJ\u000e\u0010;\u001a\u00020.2\u0006\u0010<\u001a\u00020\tJ\u000e\u0010;\u001a\u00020.2\u0006\u0010<\u001a\u00020\u0014J\b\u0010=\u001a\u00020.H\u0002J\b\u0010>\u001a\u00020.H\u0002R\u000e\u0010\u000b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/app/progresviews/ProgressLine;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defaultPaddingLeft", "defaultPaddingRight", "layoutHeight", "layoutWidth", "leftPadding", "mBarLenght", "mBarWidth", "", "mDefText", "", "mDefTextPaint", "Landroid/text/TextPaint;", "mDefTextSize", "mPercentage", "mProgressBounds", "Landroid/graphics/RectF;", "mProgressColor", "mProgressLinePaint", "Landroid/graphics/Paint;", "mScale", "mUnderLineBounds", "mUnderLineColor", "mUnderLinePaint", "mUnderLineSize", "mValueText", "mValueTextPaint", "mValueTextSize", "mValueTextWidth", "marginTopBars", "mformatter", "Ljava/text/DecimalFormat;", "paddingBetweenText", "rithPadding", "widthPaddingBetweenBars", "calculateBarScale", "", "init", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldw", "oldh", "setmDefText", "setmPercentage", "percetage", "setmValueText", "value", "setupBounds", "setupPaints", "progreswheelview_release"})
public final class ProgressLine
extends View {
    private float mBarWidth;
    private float mUnderLineSize;
    private float mValueTextSize;
    private float mDefTextSize;
    private int layoutHeight;
    private int layoutWidth;
    private int mProgressColor;
    private int mUnderLineColor;
    private final RectF mUnderLineBounds;
    private final RectF mProgressBounds;
    private final TextPaint mValueTextPaint;
    private final TextPaint mDefTextPaint;
    private final Paint mProgressLinePaint;
    private final Paint mUnderLinePaint;
    private final int marginTopBars = 30;
    private final int paddingBetweenText = 20;
    private final int defaultPaddingLeft = 30;
    private final int defaultPaddingRight = 30;
    private final int widthPaddingBetweenBars = 9;
    private final int leftPadding = 0;
    private final int rithPadding = 0;
    private String mValueText;
    private String mDefText;
    private float mValueTextWidth;
    private int mPercentage;
    private int mBarLenght;
    private float mScale;
    private final DecimalFormat mformatter;

    private final void init(AttributeSet attrs, int defStyle) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ProgressLine, defStyle, 0);
        if (a.hasValue(R.styleable.ProgressLine_value)) {
            this.mValueText = a.getString(R.styleable.ProgressLine_value);
        }
        if (a.hasValue(R.styleable.ProgressLine_definition)) {
            this.mDefText = a.getString(R.styleable.ProgressLine_definition);
        }
        this.mBarWidth = a.getDimension(R.styleable.ProgressLine_lineBarWidth, this.mBarWidth);
        this.mProgressColor = a.getColor(R.styleable.ProgressLine_lineProgressColor, this.mProgressColor);
        this.mDefTextSize = a.getDimension(R.styleable.ProgressLine_lineDefTextSize, this.mDefTextSize);
        this.mValueTextSize = a.getDimension(R.styleable.ProgressLine_valueDefTextSize, this.mValueTextSize);
        this.mPercentage = a.getInt(R.styleable.ProgressLine_valuePercentage, this.mPercentage);
        this.mUnderLineSize = a.getDimension(R.styleable.ProgressLine_underLineSize, this.mUnderLineSize);
        this.mUnderLineColor = a.getColor(R.styleable.ProgressLine_underLineColor, this.mUnderLineColor);
        this.calculateBarScale();
        a.recycle();
        this.invalidate();
    }

    private final void calculateBarScale() {
        this.mScale = this.mPercentage > 100 ? 1.0f : (float)this.mPercentage * 0.01f;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.layoutWidth = w;
        this.layoutHeight = h;
        this.setupBounds();
        this.setupPaints();
        this.invalidate();
    }

    private final void setupPaints() {
        this.mValueTextPaint.setColor(-16777216);
        this.mValueTextPaint.setFlags(1);
        this.mDefTextPaint.setColor(-16777216);
        this.mDefTextPaint.setFlags(1);
        this.mProgressLinePaint.setColor(this.mProgressColor);
        this.mProgressLinePaint.setAntiAlias(true);
        this.mProgressLinePaint.setStyle(Paint.Style.FILL);
        this.mProgressLinePaint.setStrokeWidth(this.mBarWidth);
        this.mUnderLinePaint.setColor(this.mUnderLineColor);
        this.mUnderLinePaint.setAntiAlias(true);
        this.mUnderLinePaint.setStyle(Paint.Style.FILL);
        this.mUnderLinePaint.setStrokeWidth(this.mUnderLineSize);
        this.mBarLenght = this.getWidth() - this.defaultPaddingLeft - this.defaultPaddingRight - this.getPaddingLeft() - this.getPaddingRight();
    }

    private final void setupBounds() {
        this.mValueTextPaint.setTextSize(this.mValueTextSize);
        this.mValueTextWidth = this.mValueTextPaint.measureText(this.mValueText);
        this.mDefTextPaint.setTextSize(this.mDefTextSize);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        float startX_V = this.getPaddingLeft() + this.defaultPaddingLeft;
        String string = this.mValueText;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawText(string, startX_V, (float)(this.getHeight() / 2), (Paint)this.mValueTextPaint);
        float start_D = startX_V + this.mValueTextWidth + (float)this.paddingBetweenText;
        String string2 = this.mDefText;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawText(string2, start_D, (float)(this.getHeight() / 2), (Paint)this.mDefTextPaint);
        float startX_P = this.getPaddingLeft() + this.defaultPaddingLeft;
        float endX_P = startX_P + (float)this.mBarLenght * this.mScale;
        canvas.drawLine(startX_P, (float)(this.getHeight() / 2 + this.marginTopBars), endX_P, (float)(this.getHeight() / 2 + this.marginTopBars), this.mProgressLinePaint);
        float startXU = endX_P + (float)this.widthPaddingBetweenBars;
        float endXU = startXU + (float)this.mBarLenght * (1.0f - this.mScale);
        canvas.drawLine(startXU, (float)(this.getHeight() / 2) + this.mBarWidth / (float)2 + (float)this.marginTopBars, endXU, (float)(this.getHeight() / 2) + this.mBarWidth / (float)2 + (float)this.marginTopBars, this.mUnderLinePaint);
    }

    public final void setmDefText(@NotNull String mDefText) {
        Intrinsics.checkParameterIsNotNull((Object)mDefText, (String)"mDefText");
        this.mDefText = mDefText;
        this.invalidate();
    }

    public final void setmValueText(int value) {
        this.mValueText = this.mformatter.format(value);
        this.setupBounds();
        this.setupPaints();
        this.invalidate();
    }

    public final void setmValueText(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.mValueText = value;
        this.setupBounds();
        this.setupPaints();
        this.invalidate();
    }

    public final void setmPercentage(int percetage) {
        int diff = percetage - this.mPercentage;
        new ValueAnimator();
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{this.mPercentage, this.mPercentage + diff}).setDuration(1000L);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ ProgressLine this$0;

            public final void onAnimationUpdate(ValueAnimator animation) {
                ValueAnimator valueAnimator = animation;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animation");
                Object object = valueAnimator.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                ProgressLine.access$setMPercentage$p(this.this$0, (Integer)object);
                ProgressLine.access$setupBounds(this.this$0);
                ProgressLine.access$setupPaints(this.this$0);
                ProgressLine.access$calculateBarScale(this.this$0);
                this.this$0.invalidate();
            }
            {
                this.this$0 = progressLine;
            }
        });
        valueAnimator.start();
    }

    public ProgressLine(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.mBarWidth = 24.0f;
        this.mUnderLineSize = 5.0f;
        this.mValueTextSize = 48.0f;
        this.mDefTextSize = 24.0f;
        this.mProgressColor = 1639255244;
        this.mUnderLineColor = -7829368;
        this.mUnderLineBounds = new RectF();
        this.mProgressBounds = new RectF();
        this.mValueTextPaint = new TextPaint();
        this.mDefTextPaint = new TextPaint();
        this.mProgressLinePaint = new Paint();
        this.mUnderLinePaint = new Paint();
        this.marginTopBars = 30;
        this.paddingBetweenText = 20;
        this.defaultPaddingLeft = 30;
        this.defaultPaddingRight = 30;
        this.widthPaddingBetweenBars = 9;
        this.mValueText = "6,0090";
        this.mDefText = "daily steps";
        this.mPercentage = 70;
        this.mScale = 1.0f;
        this.mformatter = new DecimalFormat("#,###,###");
        this.init(null, 0);
    }

    public ProgressLine(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.mBarWidth = 24.0f;
        this.mUnderLineSize = 5.0f;
        this.mValueTextSize = 48.0f;
        this.mDefTextSize = 24.0f;
        this.mProgressColor = 1639255244;
        this.mUnderLineColor = -7829368;
        this.mUnderLineBounds = new RectF();
        this.mProgressBounds = new RectF();
        this.mValueTextPaint = new TextPaint();
        this.mDefTextPaint = new TextPaint();
        this.mProgressLinePaint = new Paint();
        this.mUnderLinePaint = new Paint();
        this.marginTopBars = 30;
        this.paddingBetweenText = 20;
        this.defaultPaddingLeft = 30;
        this.defaultPaddingRight = 30;
        this.widthPaddingBetweenBars = 9;
        this.mValueText = "6,0090";
        this.mDefText = "daily steps";
        this.mPercentage = 70;
        this.mScale = 1.0f;
        this.mformatter = new DecimalFormat("#,###,###");
        this.init(attrs, 0);
    }

    public ProgressLine(@NotNull Context context, @NotNull AttributeSet attrs, int defStyle) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyle);
        this.mBarWidth = 24.0f;
        this.mUnderLineSize = 5.0f;
        this.mValueTextSize = 48.0f;
        this.mDefTextSize = 24.0f;
        this.mProgressColor = 1639255244;
        this.mUnderLineColor = -7829368;
        this.mUnderLineBounds = new RectF();
        this.mProgressBounds = new RectF();
        this.mValueTextPaint = new TextPaint();
        this.mDefTextPaint = new TextPaint();
        this.mProgressLinePaint = new Paint();
        this.mUnderLinePaint = new Paint();
        this.marginTopBars = 30;
        this.paddingBetweenText = 20;
        this.defaultPaddingLeft = 30;
        this.defaultPaddingRight = 30;
        this.widthPaddingBetweenBars = 9;
        this.mValueText = "6,0090";
        this.mDefText = "daily steps";
        this.mPercentage = 70;
        this.mScale = 1.0f;
        this.mformatter = new DecimalFormat("#,###,###");
        this.init(attrs, defStyle);
    }

    public static final /* synthetic */ int access$getMPercentage$p(ProgressLine $this) {
        return $this.mPercentage;
    }

    public static final /* synthetic */ void access$setMPercentage$p(ProgressLine $this, int n) {
        $this.mPercentage = n;
    }

    public static final /* synthetic */ void access$setupBounds(ProgressLine $this) {
        $this.setupBounds();
    }

    public static final /* synthetic */ void access$setupPaints(ProgressLine $this) {
        $this.setupPaints();
    }

    public static final /* synthetic */ void access$calculateBarScale(ProgressLine $this) {
        $this.calculateBarScale();
    }
}

