/*
 * Decompiled with CFR 0.152.
 */
package com.app.progresviews;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import com.app.progreswheelview.R;
import java.text.DecimalFormat;

public class ProgressLine
extends View {
    private float mBarWidth = 24.0f;
    private float mUnderLineSize = 5.0f;
    private float mValueTextSize = 48.0f;
    private float mDefTextSize = 24.0f;
    private int layoutHeight = 0;
    private int layoutWidth = 0;
    private int mProgressColor = 1639255244;
    private int mUnderLineColor = -7829368;
    private RectF mUnderLineBounds = new RectF();
    private RectF mProgressBounds = new RectF();
    private TextPaint mValueTextPaint = new TextPaint();
    private TextPaint mDefTextPaint = new TextPaint();
    private Paint mProgressLinePaint = new Paint();
    private Paint mUnderLinePaint = new Paint();
    private int marginTopBars = 30;
    private int paddingBetweenText = 20;
    private int defaultPaddingLeft = 30;
    private int defaultPaddingRight = 30;
    private int widthPaddingBetweenBars = 9;
    private int leftPadding;
    private int rithPadding;
    private String mValueText = "6,0090";
    private String mDefText = "daily steps";
    private float mValueTextWidth;
    private int mPercentage = 70;
    private int mBarLenght;
    private float mScale = 1.0f;
    private DecimalFormat mformatter = new DecimalFormat("#,###,###");

    public ProgressLine(Context context) {
        super(context);
        this.init(null, 0);
    }

    public ProgressLine(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public ProgressLine(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ProgressLine, defStyle, 0);
        if (a.hasValue(R.styleable.ProgressLine_value)) {
            this.mValueText = a.getString(R.styleable.ProgressLine_value);
        }
        if (a.hasValue(R.styleable.ProgressLine_definition)) {
            this.mDefText = a.getString(R.styleable.ProgressLine_definition);
        }
        this.mBarWidth = a.getDimension(R.styleable.ProgressLine_lineBarWidth, this.mBarWidth);
        this.mProgressColor = a.getColor(R.styleable.ProgressLine_lineProgressColor, this.mProgressColor);
        this.mDefTextSize = a.getDimension(R.styleable.ProgressLine_lineDefTextSize, this.mDefTextSize);
        this.mValueTextSize = a.getDimension(R.styleable.ProgressLine_valueDefTextSize, this.mValueTextSize);
        this.mPercentage = a.getInt(R.styleable.ProgressLine_valuePercentage, this.mPercentage);
        this.mUnderLineSize = a.getDimension(R.styleable.ProgressLine_underLineSize, this.mUnderLineSize);
        this.mUnderLineColor = a.getColor(R.styleable.ProgressLine_underLineColor, this.mUnderLineColor);
        this.calculateBarScale();
        a.recycle();
        this.invalidate();
    }

    private void calculateBarScale() {
        this.mScale = this.mPercentage > 100 ? 1.0f : (float)this.mPercentage * 0.01f;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.layoutWidth = w;
        this.layoutHeight = h;
        this.setupBounds();
        this.setupPaints();
        this.invalidate();
    }

    private void setupPaints() {
        this.mValueTextPaint.setColor(-16777216);
        this.mValueTextPaint.setFlags(1);
        this.mDefTextPaint.setColor(-16777216);
        this.mDefTextPaint.setFlags(1);
        this.mProgressLinePaint.setColor(this.mProgressColor);
        this.mProgressLinePaint.setAntiAlias(true);
        this.mProgressLinePaint.setStyle(Paint.Style.FILL);
        this.mProgressLinePaint.setStrokeWidth(this.mBarWidth);
        this.mUnderLinePaint.setColor(this.mUnderLineColor);
        this.mUnderLinePaint.setAntiAlias(true);
        this.mUnderLinePaint.setStyle(Paint.Style.FILL);
        this.mUnderLinePaint.setStrokeWidth(this.mUnderLineSize);
        this.mBarLenght = this.getWidth() - this.defaultPaddingLeft - this.defaultPaddingRight - this.getPaddingLeft() - this.getPaddingRight();
    }

    private void setupBounds() {
        this.mValueTextPaint.setTextSize(this.mValueTextSize);
        this.mValueTextWidth = this.mValueTextPaint.measureText(this.mValueText);
        this.mDefTextPaint.setTextSize(this.mDefTextSize);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float startX_V = this.getPaddingLeft() + this.defaultPaddingLeft;
        canvas.drawText(this.mValueText, startX_V, (float)(this.getHeight() / 2), (Paint)this.mValueTextPaint);
        float start_D = startX_V + this.mValueTextWidth + (float)this.paddingBetweenText;
        canvas.drawText(this.mDefText, start_D, (float)(this.getHeight() / 2), (Paint)this.mDefTextPaint);
        float startX_P = this.getPaddingLeft() + this.defaultPaddingLeft;
        float endX_P = startX_P + (float)this.mBarLenght * this.mScale;
        canvas.drawLine(startX_P, (float)(this.getHeight() / 2 + this.marginTopBars), endX_P, (float)(this.getHeight() / 2 + this.marginTopBars), this.mProgressLinePaint);
        float startX_U = endX_P + (float)this.widthPaddingBetweenBars;
        float endX_U = startX_U + (float)this.mBarLenght * (1.0f - this.mScale);
        canvas.drawLine(startX_U, (float)(this.getHeight() / 2) + this.mBarWidth / 2.0f + (float)this.marginTopBars, endX_U, (float)(this.getHeight() / 2) + this.mBarWidth / 2.0f + (float)this.marginTopBars, this.mUnderLinePaint);
    }

    public void setmDefText(String mDefText) {
        this.mDefText = mDefText;
        this.invalidate();
    }

    public void setmValueText(int value) {
        this.mValueText = this.mformatter.format(value);
        this.invalidate();
    }

    public void setmPercentage(int mPercentage) {
        this.mPercentage = mPercentage;
        this.calculateBarScale();
        this.invalidate();
    }
}

