/*
 * Decompiled with CFR 0.152.
 */
package com.zegome.utils.widget;

import android.content.Context;
import android.support.v4.widget.NestedScrollView;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;

public class ZNestedScrollView
extends NestedScrollView {
    private OnScrollListener mScrollListener;
    private GestureDetector mGestureDetector;
    private boolean mIsCheckGesture = true;

    public ZNestedScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new YDeepScrollDetector());
        this.setFadingEdgeLength(0);
    }

    public void setCheckGesture(boolean checkGesture) {
        this.mIsCheckGesture = checkGesture;
    }

    public void setScrollListener(OnScrollListener scrollListener) {
        this.mScrollListener = scrollListener;
    }

    public boolean startNestedScroll(int axes) {
        if (this.mScrollListener != null) {
            this.mScrollListener.onStart();
        }
        return super.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        super.stopNestedScroll();
        if (this.mScrollListener != null) {
            this.mScrollListener.onStop();
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return super.onInterceptTouchEvent(ev) && (!this.mIsCheckGesture || this.mGestureDetector.onTouchEvent(ev));
    }

    public static interface OnScrollListener {
        public void onStop();

        public void onStart();

        public boolean isScrolling();
    }

    private class YDeepScrollDetector
    extends GestureDetector.SimpleOnGestureListener {
        private YDeepScrollDetector() {
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            return Math.abs(distanceY) > Math.abs(distanceX) && (Math.abs(distanceY) >= Math.abs(distanceX) * 5.0f || distanceX == 0.0f);
        }
    }
}

