/*
 * Decompiled with CFR 0.152.
 */
package com.zegome.utils.xml;

import com.zegome.utils.xml.XMLNode;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParserHanler
extends DefaultHandler {
    private final ArrayList<XMLNode> mNodeList = new ArrayList();
    private XMLNodeKeyFactory mKeyFactory;
    private StringBuilder mBuilder;
    private String mParentNode;
    private XMLNode mNode;

    public XMLParserHanler(String parent, XMLNodeKeyFactory keyFactory) {
        this.mParentNode = parent;
        this.setKeys(keyFactory);
    }

    public ArrayList<XMLNode> getResult() {
        return this.mNodeList;
    }

    public void setKeys(XMLNodeKeyFactory keyFactory) {
        this.mKeyFactory = keyFactory;
    }

    public void setParentNode(String parent) {
        this.mParentNode = parent;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.mBuilder = new StringBuilder();
        if (localName.equals(this.mParentNode)) {
            ArrayList<String> keys = this.mKeyFactory.getKeys();
            this.mNode = new XMLNode(this.mParentNode, keys);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals(this.mParentNode)) {
            this.mNodeList.add(this.mNode);
            this.mNode = null;
        } else if (this.mNode != null && this.mNode.check(localName)) {
            this.mNode.setValue(localName, this.mBuilder.toString());
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String tempString = new String(ch, start, length);
        this.mBuilder.append(tempString);
    }

    public static interface XMLNodeKeyFactory {
        public ArrayList<String> getKeys();
    }
}

