/*
 * Decompiled with CFR 0.152.
 */
package com.zegome.utils.animation.impl;

import com.zegome.utils.animation.IAnimation;
import com.zegome.utils.animation.IUpdate;

public class ZAnimation
implements IAnimation {
    private static final float ONE_SECOND = 1000.0f;
    protected float mFromValue = 0.0f;
    protected float mToValue = 0.0f;
    protected float mCurrentValue = 0.0f;
    protected float mProgress = 0.0f;
    protected IUpdate.IUpdatable mParent = null;
    protected float mDuration = 0.0f;
    protected float mUpdatedTime = 0.0f;
    private float mDiffValue = 0.0f;
    protected boolean mIsRunning = false;
    protected boolean mIsAutoRemove = false;

    private ZAnimation() {
    }

    @Override
    public float getValue() {
        return this.mCurrentValue;
    }

    @Override
    public boolean isRunning() {
        return this.mIsRunning;
    }

    @Override
    public boolean isAutoRemove() {
        return this.mIsAutoRemove;
    }

    @Override
    public void setAutoRemove(boolean autoRemove) {
        this.mIsAutoRemove = autoRemove;
    }

    @Override
    public IUpdate.IUpdatable getParent() {
        return this.mParent;
    }

    @Override
    public void setParent(IUpdate.IUpdatable updatable) {
        this.mParent = updatable;
    }

    @Override
    public IAnimation from(float fromValue) {
        this.mFromValue = fromValue;
        return this;
    }

    @Override
    public IAnimation to(float toValue) {
        this.mToValue = toValue;
        return this;
    }

    @Override
    public IAnimation duration(long timeMiliseconds) {
        this.mDuration = (float)timeMiliseconds / 1000.0f;
        return this;
    }

    @Override
    public void onUpdate(float delta) {
        this.mUpdatedTime += delta;
        this.mProgress = this.mUpdatedTime / this.mDuration;
        if (this.mUpdatedTime >= this.mDuration) {
            this.mProgress = 1.0f;
        }
        this.mCurrentValue = this.mProgress * this.mDiffValue + this.mFromValue;
    }

    @Override
    public void onPost() {
    }

    @Override
    public void removeSelf() {
        this.mIsRunning = false;
    }

    @Override
    public void start() {
        if (this.mDuration <= 0.0f || this.mFromValue == this.mToValue) {
            throw new IllegalArgumentException("duration must be difference 0, fromValue and toValue must be difference");
        }
        this.mIsRunning = true;
        this.mUpdatedTime = 0.0f;
        this.calculate();
    }

    @Override
    public void stop() {
        this.mIsRunning = false;
        this.removeSelf();
    }

    public static ZAnimation create() {
        return new ZAnimation();
    }

    private void calculate() {
        this.mDiffValue = this.mFromValue - this.mToValue;
    }
}

