/*
 * Decompiled with CFR 0.152.
 */
package com.zegome.utils.widget.pager;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.animation.Interpolator;
import com.zegome.utils.widget.pager.ZDurationScroller;
import java.lang.reflect.Field;

public class ZViewPager
extends ViewPager {
    private boolean isSwipe = false;
    private boolean isAnimation = true;
    protected ZDurationScroller mScroller = null;

    public ZViewPager(Context context) {
        super(context);
        this.postInitViewPager();
    }

    public ZViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.postInitViewPager();
    }

    public void setSwipe(boolean swipe) {
        this.isSwipe = swipe;
    }

    public void setAni(boolean animation) {
        this.isAnimation = animation;
    }

    public void setCurrentItem(int item) {
        super.setCurrentItem(item, this.isAnimation);
    }

    public void setScrollDurationFactor(double scrollFactor) {
        if (null == this.mScroller) {
            return;
        }
        this.mScroller.setScrollDurationFactor(scrollFactor);
    }

    public long getScrollDuration() {
        return null != this.mScroller ? this.mScroller.getDuration() : 0;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (this.isSwipe) {
            return super.onInterceptTouchEvent(event);
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isSwipe) {
            return super.onTouchEvent(event);
        }
        return false;
    }

    private void postInitViewPager() {
        this.isSwipe = false;
        this.isAnimation = false;
        try {
            Field scroller = ViewPager.class.getDeclaredField("mScroller");
            scroller.setAccessible(true);
            Field interpolator = ViewPager.class.getDeclaredField("sInterpolator");
            interpolator.setAccessible(true);
            this.mScroller = new ZDurationScroller(this.getContext(), (Interpolator)interpolator.get(null));
            scroller.set((Object)this, (Object)this.mScroller);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

