/*
 * Decompiled with CFR 0.152.
 */
package com.zegome.utils.widget.pager;

import android.support.v4.view.ViewPager;
import android.view.View;

public class SimpleViewPagerTransformer
implements ViewPager.PageTransformer {
    private final TransformType mTransformType;
    private static final float MIN_SCALE_DEPTH = 0.75f;
    private static final float MIN_SCALE_ZOOM = 0.85f;
    private static final float MIN_ALPHA_ZOOM = 0.0f;
    private static final float SCALE_FACTOR_SLIDE = 0.85f;
    private static final float MIN_ALPHA_SLIDE = 0.35f;

    public SimpleViewPagerTransformer(TransformType transformType) {
        this.mTransformType = transformType;
    }

    public void transformPage(View page, float position) {
        float translationX;
        float alpha;
        float scale;
        switch (this.mTransformType) {
            case FLOW: {
                page.setRotationY(position * -30.0f);
                return;
            }
            case SLIDE_OVER: {
                if (position < 0.0f && position > -1.0f) {
                    scale = Math.abs(Math.abs(position) - 1.0f) * 0.14999998f + 0.85f;
                    alpha = Math.max(0.35f, 1.0f - Math.abs(position));
                    int pageWidth = page.getWidth();
                    float translateValue = position * (float)(-pageWidth);
                    if (translateValue > (float)(-pageWidth)) {
                        translationX = translateValue;
                        break;
                    }
                    translationX = 0.0f;
                    break;
                }
                alpha = 1.0f;
                scale = 1.0f;
                translationX = 0.0f;
                break;
            }
            case DEPTH: {
                if (position > 0.0f && position < 1.0f) {
                    alpha = 1.0f - position;
                    scale = 0.75f + 0.25f * (1.0f - Math.abs(position));
                    translationX = (float)page.getWidth() * -position;
                    break;
                }
                alpha = 1.0f;
                scale = 1.0f;
                translationX = 0.0f;
                break;
            }
            case ZOOM: {
                if (position >= -1.0f && position <= 1.0f) {
                    scale = Math.max(0.85f, 1.0f - Math.abs(position));
                    alpha = 0.0f + (scale - 0.85f) / 0.14999998f * 1.0f;
                    float vMargin = (float)page.getHeight() * (1.0f - scale) / 2.0f;
                    float hMargin = (float)page.getWidth() * (1.0f - scale) / 2.0f;
                    if (position < 0.0f) {
                        translationX = hMargin - vMargin / 2.0f;
                        break;
                    }
                    translationX = -hMargin + vMargin / 2.0f;
                    break;
                }
                alpha = 1.0f;
                scale = 1.0f;
                translationX = 0.0f;
                break;
            }
            default: {
                return;
            }
        }
        page.setAlpha(alpha);
        page.setTranslationX(translationX);
        page.setScaleX(scale);
        page.setScaleY(scale);
    }

    public static enum TransformType {
        FLOW,
        DEPTH,
        ZOOM,
        SLIDE_OVER;

    }
}

