/*
 * Decompiled with CFR 0.152.
 */
package com.zegome.utils.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.widget.AbsListView;
import android.widget.ListView;
import com.zegome.utils.widget.ZSwipeRefreshLayout;

public class ZListViewRefreshLoadMore
extends ZSwipeRefreshLayout {
    private final int mTouchSlop;
    private ListView mListView;
    private ILoadMoreListener mLoadMoreListener;
    private float mFirstY;
    private float mLastY;
    private boolean mIsLoading = false;
    private boolean mIsLoadMore = true;

    public ZListViewRefreshLoadMore(Context context) {
        this(context, null);
    }

    public ZListViewRefreshLoadMore(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
    }

    public void setLoadMore(boolean isLoadMore) {
        this.mIsLoadMore = isLoadMore;
    }

    public void setListView(ListView listView) {
        this.mListView = listView;
        this.mListView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                switch (scrollState) {
                    case 2: {
                        break;
                    }
                    case 0: {
                        if (!ZListViewRefreshLoadMore.this.checkIfLoadMorable()) break;
                        ZListViewRefreshLoadMore.this.loadMore(true);
                    }
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            }
        });
    }

    public void setLoadMoreListener(ILoadMoreListener listener) {
        this.mLoadMoreListener = listener;
    }

    private boolean isBottom() {
        if (this.mListView.getChildCount() > 0) {
            try {
                int con1 = this.mListView.getLastVisiblePosition();
                int con2 = this.mListView.getAdapter().getCount() - 1;
                int con3 = this.mListView.getChildCount() > 0 ? this.mListView.getChildAt(this.mListView.getChildCount() - 1).getTop() : 0;
                int con4 = this.mListView.getHeight();
                if (con1 == con2 && con3 <= con4) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    private boolean isPullingUp() {
        return this.mFirstY - this.mLastY > (float)this.mTouchSlop;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int action = ev.getAction() & 0xFF;
        switch (action) {
            case 0: {
                this.mFirstY = ev.getRawY();
                break;
            }
            case 1: {
                this.mLastY = ev.getRawY();
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    private boolean checkIfLoadMorable() {
        return this.mIsLoadMore && this.isBottom() && !this.mIsLoading && this.isPullingUp();
    }

    private void checkLoadMoreListener() {
        if (this.mLoadMoreListener != null) {
            this.mLoadMoreListener.onLoadMore();
        }
    }

    public void loadMore(boolean load) {
        if (this.mListView == null) {
            return;
        }
        this.mIsLoading = load;
        if (load) {
            if (this.isRefreshing()) {
                this.setRefreshing(false);
            }
            if (this.mListView.getAdapter().getCount() > 0) {
                this.mListView.setSelection(this.mListView.getAdapter().getCount() - 1);
            }
            this.checkLoadMoreListener();
        } else {
            this.resetTouch();
        }
    }

    private void resetTouch() {
        this.mFirstY = 0.0f;
        this.mLastY = 0.0f;
    }

    public static interface ILoadMoreListener {
        public void onLoadMore();
    }
}

