/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.sansorm.internal;

import com.zaxxer.sansorm.internal.FieldColumnInfo;
import com.zaxxer.sansorm.internal.Introspected;
import com.zaxxer.sansorm.internal.Introspector;
import com.zaxxer.sansorm.internal.OrmBase;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class OrmWriter
extends OrmBase {
    private static final int CACHE_SIZE = Integer.getInteger("com.zaxxer.sansorm.statementCacheSize", 500);
    private static final Map<Introspected, String> createStatementCache = Collections.synchronizedMap(new LinkedHashMap<Introspected, String>(CACHE_SIZE){
        private static final long serialVersionUID = 4559270460685275064L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Introspected, String> eldest) {
            return this.size() > CACHE_SIZE;
        }
    });
    private static final Map<Introspected, String> updateStatementCache = Collections.synchronizedMap(new LinkedHashMap<Introspected, String>(CACHE_SIZE){
        private static final long serialVersionUID = -5324251353646078607L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Introspected, String> eldest) {
            return this.size() > CACHE_SIZE;
        }
    });

    public static <T> void insertListBatched(Connection connection, Iterable<T> iterable) throws SQLException {
        Iterator<T> iterableIterator = iterable.iterator();
        if (!iterableIterator.hasNext()) {
            return;
        }
        Class<?> clazz = iterableIterator.next().getClass();
        Introspected introspected = Introspector.getIntrospected(clazz);
        boolean hasSelfJoinColumn = introspected.hasSelfJoinColumn();
        if (hasSelfJoinColumn) {
            throw new RuntimeException("insertListBatched() is not supported for objects with self-referencing columns due to Derby limitations");
        }
        FieldColumnInfo[] insertableFcInfos = introspected.getInsertableFcInfos();
        try (PreparedStatement stmt = OrmWriter.createStatementForInsert(connection, introspected, insertableFcInfos);){
            int[] parameterTypes = OrmWriter.getParameterTypes(stmt);
            for (T item : iterable) {
                OrmWriter.setStatementParameters(item, introspected, insertableFcInfos, stmt, parameterTypes, null);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
    }

    public static <T> void insertListNotBatched(Connection connection, Iterable<T> iterable) throws SQLException {
        Iterator<T> iterableIterator = iterable.iterator();
        if (!iterableIterator.hasNext()) {
            return;
        }
        Class<?> clazz = iterableIterator.next().getClass();
        Introspected introspected = Introspector.getIntrospected(clazz);
        boolean hasSelfJoinColumn = introspected.hasSelfJoinColumn();
        String[] idColumnNames = introspected.getIdColumnNames();
        FieldColumnInfo[] insertableFcInfos = introspected.getInsertableFcInfos();
        try (PreparedStatement stmt = OrmWriter.createStatementForInsert(connection, introspected, insertableFcInfos);){
            int[] parameterTypes = OrmWriter.getParameterTypes(stmt);
            for (T item : iterable) {
                OrmWriter.setStatementParameters(item, introspected, insertableFcInfos, stmt, parameterTypes, null);
                stmt.executeUpdate();
                OrmWriter.fillGeneratedId(item, introspected, stmt, false);
                stmt.clearParameters();
            }
        }
        if (hasSelfJoinColumn) {
            FieldColumnInfo selfJoinfcInfo = introspected.getSelfJoinColumnInfo();
            String idColumn = idColumnNames[0];
            StringBuilder sql = new StringBuilder("UPDATE ").append(introspected.getTableName()).append(" SET ").append(selfJoinfcInfo.getDelimitedColumnName()).append("=? WHERE ").append(idColumn).append("=?");
            try (PreparedStatement stmt = connection.prepareStatement(sql.toString());){
                for (T item : iterable) {
                    Object referencedItem = introspected.get(item, selfJoinfcInfo);
                    if (referencedItem == null) continue;
                    stmt.setObject(1, introspected.getActualIds(referencedItem)[0]);
                    stmt.setObject(2, introspected.getActualIds(item)[0]);
                    stmt.addBatch();
                    stmt.clearParameters();
                }
                stmt.executeBatch();
            }
        }
    }

    public static <T> T insertObject(Connection connection, T target) throws SQLException {
        Class<?> clazz = target.getClass();
        Introspected introspected = Introspector.getIntrospected(clazz);
        FieldColumnInfo[] insertableFcInfos = introspected.getInsertableFcInfos();
        try (PreparedStatement stmt = OrmWriter.createStatementForInsert(connection, introspected, insertableFcInfos);){
            OrmWriter.setParamsExecute(target, introspected, insertableFcInfos, stmt, false, null);
        }
        return target;
    }

    public static <T> T updateObject(Connection connection, T target) throws SQLException {
        return OrmWriter.updateObject(connection, target, null);
    }

    public static <T> T updateObject(Connection connection, T target, Set<String> excludedColumns) throws SQLException {
        Class<?> clazz = target.getClass();
        Introspected introspected = Introspector.getIntrospected(clazz);
        FieldColumnInfo[] updatableFcInfos = introspected.getUpdatableFcInfos();
        if (excludedColumns == null) {
            try (PreparedStatement stmt = OrmWriter.createStatementForUpdate(connection, introspected, updatableFcInfos);){
                OrmWriter.setParamsExecute(target, introspected, updatableFcInfos, stmt, true, null);
            }
        }
        try (PreparedStatement stmt = OrmWriter.createStatementForUpdate(connection, introspected, updatableFcInfos, excludedColumns);){
            OrmWriter.setParamsExecute(target, introspected, updatableFcInfos, stmt, true, excludedColumns);
        }
        return target;
    }

    public static <T> int deleteObject(Connection connection, T target) throws SQLException {
        Class<?> clazz = target.getClass();
        Introspected introspected = Introspector.getIntrospected(clazz);
        return OrmWriter.deleteObjectById(connection, clazz, introspected.getActualIds(target));
    }

    public static <T> int deleteObjectById(Connection connection, Class<T> clazz, Object ... args) throws SQLException {
        Introspected introspected = Introspector.getIntrospected(clazz);
        StringBuilder sql = new StringBuilder().append("DELETE FROM ").append(introspected.getTableName()).append(" WHERE ");
        String[] idColumnNames = introspected.getIdColumnNames();
        if (idColumnNames.length == 0) {
            throw new RuntimeException("No id columns provided in: " + clazz.getName());
        }
        for (String idColumn : idColumnNames) {
            sql.append(idColumn).append("=? AND ");
        }
        sql.setLength(sql.length() - 5);
        return OrmWriter.executeUpdate(connection, sql.toString(), args);
    }

    public static int executeUpdate(Connection connection, String sql, Object ... args) throws SQLException {
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            OrmWriter.populateStatementParameters(stmt, args);
            int n = stmt.executeUpdate();
            return n;
        }
    }

    private static PreparedStatement createStatementForInsert(Connection connection, Introspected introspected, FieldColumnInfo[] fcInfos) throws SQLException {
        String sql = createStatementCache.computeIfAbsent(introspected, key -> {
            String tableName = introspected.getTableName();
            StringBuilder sqlSB = new StringBuilder("INSERT INTO ").append(tableName).append('(');
            StringBuilder sqlValues = new StringBuilder(") VALUES (");
            for (FieldColumnInfo fcInfo : fcInfos) {
                sqlSB.append(fcInfo.getDelimitedColumnName()).append(',');
                sqlValues.append("?,");
            }
            sqlValues.deleteCharAt(sqlValues.length() - 1);
            sqlSB.deleteCharAt(sqlSB.length() - 1).append((CharSequence)sqlValues).append(')');
            return sqlSB.toString();
        });
        if (introspected.hasGeneratedId()) {
            return connection.prepareStatement(sql, introspected.getIdColumnNames());
        }
        return connection.prepareStatement(sql);
    }

    private static PreparedStatement createStatementForUpdate(Connection connection, Introspected introspected, FieldColumnInfo[] fieldColumnInfos) throws SQLException {
        String sql = updateStatementCache.computeIfAbsent(introspected, key -> OrmWriter.createSqlForUpdate(introspected, fieldColumnInfos, null));
        return connection.prepareStatement(sql);
    }

    private static PreparedStatement createStatementForUpdate(Connection connection, Introspected introspected, FieldColumnInfo[] fieldColumnInfos, Set<String> excludedColumns) throws SQLException {
        String sql = OrmWriter.createSqlForUpdate(introspected, fieldColumnInfos, excludedColumns);
        return connection.prepareStatement(sql);
    }

    private static String createSqlForUpdate(Introspected introspected, FieldColumnInfo[] fieldColumnInfos, Set<String> excludedColumns) {
        StringBuilder sqlSB = new StringBuilder("UPDATE ").append(introspected.getTableName()).append(" SET ");
        for (FieldColumnInfo fcInfo : fieldColumnInfos) {
            if (excludedColumns != null && OrmWriter.isIgnoredColumn(excludedColumns, fcInfo.getColumnName())) continue;
            sqlSB.append(fcInfo.getDelimitedColumnName()).append("=?,");
        }
        sqlSB.deleteCharAt(sqlSB.length() - 1);
        String[] idColumnNames = introspected.getIdColumnNames();
        if (idColumnNames.length > 0) {
            sqlSB.append(" WHERE ");
            for (String column : idColumnNames) {
                sqlSB.append(column).append("=? AND ");
            }
            sqlSB.setLength(sqlSB.length() - 5);
        }
        return sqlSB.toString();
    }

    private static <T> void setParamsExecute(T target, Introspected introspected, FieldColumnInfo[] fcInfos, PreparedStatement stmt, boolean checkExistingId, Set<String> excludedColumns) throws SQLException {
        int[] parameterTypes = OrmWriter.getParameterTypes(stmt);
        int parameterIndex = OrmWriter.setStatementParameters(target, introspected, fcInfos, stmt, parameterTypes, excludedColumns);
        if (parameterIndex <= parameterTypes.length) {
            for (Object id : introspected.getActualIds(target)) {
                stmt.setObject(parameterIndex, id, parameterTypes[parameterIndex - 1]);
                ++parameterIndex;
            }
        }
        stmt.executeUpdate();
        OrmWriter.fillGeneratedId(target, introspected, stmt, checkExistingId);
    }

    private static <T> int setStatementParameters(T item, Introspected introspected, FieldColumnInfo[] fcInfos, PreparedStatement stmt, int[] parameterTypes, Set<String> excludedColumns) throws SQLException {
        int parameterIndex = 1;
        for (FieldColumnInfo fcInfo : fcInfos) {
            if (excludedColumns != null && OrmWriter.isIgnoredColumn(excludedColumns, fcInfo.getColumnName())) continue;
            int parameterType = parameterTypes[parameterIndex - 1];
            Object object = OrmWriter.mapSqlType(introspected.get(item, fcInfo), parameterType);
            if (object != null && !fcInfo.isSelfJoinField()) {
                stmt.setObject(parameterIndex, object, parameterType);
            } else {
                stmt.setNull(parameterIndex, parameterType);
            }
            ++parameterIndex;
        }
        return parameterIndex;
    }

    private static <T> void fillGeneratedId(T target, Introspected introspected, PreparedStatement stmt, boolean checkExistingId) throws SQLException {
        Object idExisting;
        if (!introspected.hasGeneratedId()) {
            return;
        }
        FieldColumnInfo fcInfo = introspected.getGeneratedIdFcInfo();
        if (checkExistingId && (idExisting = introspected.get(target, fcInfo)) != null && (!(idExisting instanceof Integer) || (Integer)idExisting > 0)) {
            return;
        }
        try (ResultSet generatedKeys = stmt.getGeneratedKeys();){
            if (generatedKeys.next()) {
                introspected.set(target, fcInfo, generatedKeys.getObject(1));
            }
        }
    }

    private static int[] getParameterTypes(PreparedStatement stmt) throws SQLException {
        ParameterMetaData metaData = stmt.getParameterMetaData();
        int[] parameterTypes = new int[metaData.getParameterCount()];
        for (int parameterIndex = 1; parameterIndex <= metaData.getParameterCount(); ++parameterIndex) {
            parameterTypes[parameterIndex - 1] = metaData.getParameterType(parameterIndex);
        }
        return parameterTypes;
    }
}

