/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.sansorm.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;

public class ConnectionProxy
implements InvocationHandler {
    private final ArrayList<Statement> statements;
    private final Connection delegate;

    private ConnectionProxy(Connection delegate) {
        this.delegate = delegate;
        this.statements = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret;
        if ("close".equals(method.getName())) {
            try {
                for (Statement stmt : this.statements) {
                    stmt.close();
                }
            }
            finally {
                this.statements.clear();
            }
        }
        if ((ret = method.invoke((Object)this.delegate, args)) instanceof Statement) {
            this.statements.add((Statement)ret);
        }
        return ret;
    }

    public static Connection wrapConnection(Connection delegate) {
        ConnectionProxy handler = new ConnectionProxy(delegate);
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)handler);
    }
}

