/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.util;

import com.zaxxer.hikari.pool.PoolBagEntry;
import com.zaxxer.hikari.util.ConcurrentBag;
import com.zaxxer.hikari.util.IBagStateListener;
import com.zaxxer.hikari.util.UtilityElf;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.AbstractQueuedLongSynchronizer;

public final class Java6ConcurrentBag
extends ConcurrentBag<PoolBagEntry> {
    public Java6ConcurrentBag(IBagStateListener listener) {
        super(listener);
    }

    @Override
    protected AbstractQueuedLongSynchronizer createQueuedSynchronizer() {
        return new Synchronizer();
    }

    @Override
    public List<PoolBagEntry> values(int state) {
        ArrayList<PoolBagEntry> list = new ArrayList<PoolBagEntry>(this.sharedList.size());
        if (state == 1 || state == 0) {
            for (PoolBagEntry reference : this.sharedList) {
                if (reference.state.get() != state) continue;
                list.add(reference);
            }
        }
        return list;
    }

    @Override
    public int getCount(int state) {
        int count = 0;
        for (PoolBagEntry reference : this.sharedList) {
            if (reference.state.get() != state) continue;
            ++count;
        }
        return count;
    }

    private static final class Synchronizer
    extends AbstractQueuedLongSynchronizer {
        private static final long serialVersionUID = 104753538004341218L;

        private Synchronizer() {
        }

        @Override
        protected long tryAcquireShared(long seq) {
            return this.getState() > seq && !this.java67hasQueuedPredecessors() ? 1L : -1L;
        }

        @Override
        protected boolean tryReleaseShared(long updateSeq) {
            this.setState(updateSeq);
            return true;
        }

        private boolean java67hasQueuedPredecessors() {
            if (UtilityElf.IS_JAVA7) {
                return this.hasQueuedPredecessors();
            }
            return false;
        }
    }
}

