/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.gnip;

import com.zaubersoftware.gnip4j.api.GnipFacade;
import com.zaubersoftware.gnip4j.api.GnipStream;
import com.zaubersoftware.gnip4j.api.StreamNotification;
import com.zaubersoftware.gnip4j.api.StreamNotificationAdapter;
import com.zaubersoftware.gnip4j.api.model.Activity;
import org.apache.commons.lang.UnhandledException;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.ConnectException;
import org.mule.transport.gnip.GnipConnector;

public class GnipMessageReceiver
extends AbstractMessageReceiver {
    private GnipStream stream;

    public GnipMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
    }

    public final void doConnect() throws ConnectException {
        String uri = this.getEndpointURI().getPath();
        String account = uri.substring(uri.indexOf("accounts/") + "accounts/".length(), uri.indexOf("/publishers"));
        String streamName = uri.substring(uri.indexOf("streams/track/") + "streams/track/".length(), uri.indexOf(".json"));
        this.stream = this.getGnipFacade().createStream(account, streamName, (StreamNotification)new StreamNotificationAdapter(){

            public void notify(Activity activity, GnipStream stream) {
                try {
                    GnipMessageReceiver.this.routeMessage(GnipMessageReceiver.this.createMuleMessage(activity));
                }
                catch (MuleException e) {
                    throw new UnhandledException((Throwable)e);
                }
            }
        });
    }

    public final GnipFacade getGnipFacade() {
        return ((GnipConnector)this.getConnector()).getFacade();
    }

    public void doDisconnect() throws ConnectException {
    }

    public void doStart() {
    }

    public void doStop() {
    }

    public final void doDispose() {
        this.stream.close();
    }
}

