/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.vm;

import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.transport.AbstractMessageRequester;
import org.mule.transport.vm.VMConnector;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueSession;

public class VMMessageRequester
extends AbstractMessageRequester {
    private final VMConnector connector;

    public VMMessageRequester(InboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (VMConnector)endpoint.getConnector();
    }

    protected MuleMessage doRequest(long timeout) throws Exception {
        QueueSession queueSession = this.connector.getQueueSession();
        Queue queue = queueSession.getQueue(this.endpoint.getEndpointURI().getAddress());
        if (queue == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No queue with name " + this.endpoint.getEndpointURI().getAddress()));
            }
            return null;
        }
        MuleEvent event = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Waiting for a message on " + this.endpoint.getEndpointURI().getAddress()));
        }
        try {
            event = (MuleEvent)queue.poll(timeout);
        }
        catch (InterruptedException e) {
            this.logger.error((Object)("Failed to receive message from queue: " + this.endpoint.getEndpointURI()));
        }
        if (event != null) {
            if (event.getMessage() instanceof ThreadSafeAccess) {
                ((ThreadSafeAccess)event.getMessage()).resetAccessControl();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message received: " + event));
            }
            return event.getMessage();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No event received after " + timeout + " ms"));
        }
        return null;
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
        this.connector.getQueueProfile().configureQueue(this.endpoint.getEndpointURI().getAddress(), this.connector.getQueueManager());
    }

    protected void doDisconnect() throws Exception {
    }
}

