/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import java.util.HashMap;
import java.util.Map;
import org.mule.config.spring.parsers.assembly.configuration.ValueMap;
import org.mule.config.spring.parsers.specific.FilterDefinitionParser;
import org.mule.routing.filters.RegExFilter;
import org.mule.util.StringUtils;

public class RegExFilterDefinitionParser
extends FilterDefinitionParser {
    public RegExFilterDefinitionParser() {
        super(RegExFilter.class);
        this.addMapping("flags", new FlagsMapping());
    }

    public static class FlagsMapping
    implements ValueMap {
        private static final Map<String, Integer> FlagsMapping = new HashMap<String, Integer>();

        public Object rewrite(String value) {
            String[] flagStrings;
            int combinedFlags = 0;
            for (String flagString : flagStrings = StringUtils.split((String)value, (char)',')) {
                Integer flag = FlagsMapping.get(flagString);
                if (flag == null) {
                    String message = String.format("Invalid flag '%1s'. Must be one of %2s", flagString, FlagsMapping.keySet().toString());
                    throw new IllegalArgumentException(message);
                }
                combinedFlags |= flag.intValue();
            }
            return combinedFlags;
        }

        static {
            FlagsMapping.put("CANON_EQ", 128);
            FlagsMapping.put("CASE_INSENSITIVE", 2);
            FlagsMapping.put("DOTALL", 32);
            FlagsMapping.put("MULTILINE", 8);
            FlagsMapping.put("UNICODE_CASE", 64);
        }
    }
}

