/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.generic;

import java.util.List;
import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.assembly.BeanAssemblerFactory;
import org.mule.config.spring.parsers.assembly.DefaultBeanAssembler;
import org.mule.config.spring.parsers.assembly.DefaultBeanAssemblerFactory;
import org.mule.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.config.spring.parsers.generic.ChildDefinitionParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.w3c.dom.Element;

public class WrappingChildDefinitionParser
extends ChildDefinitionParser {
    private final Class wrapperClass;
    private final String propertyNameInWrapper;
    private final String unwrappedPropertyName;
    private final WrappingController wrappingController;

    public WrappingChildDefinitionParser(String setterMethod, Class clazz, Class constraint, boolean allowClassAttribute, Class wrapperClass, String propertyNameInWrapper, String unwrappedPropertyName, WrappingController wrappingController) {
        super(setterMethod, clazz, constraint, allowClassAttribute);
        this.wrapperClass = wrapperClass;
        this.propertyNameInWrapper = propertyNameInWrapper;
        this.unwrappedPropertyName = unwrappedPropertyName;
        this.wrappingController = wrappingController;
    }

    public String getPropertyName(Element e) {
        if (!this.wrappingController.shouldWrap(e)) {
            return this.unwrappedPropertyName;
        }
        return super.getPropertyName(e);
    }

    protected void preProcess(Element element) {
        super.preProcess(element);
        if (this.wrappingController.shouldWrap(element)) {
            this.setBeanAssemblerFactory(new MessageProcessorWrappingBeanAssemblerFactory(this.wrapperClass, this.propertyNameInWrapper));
        } else {
            this.setBeanAssemblerFactory(new DefaultBeanAssemblerFactory());
        }
    }

    private static class MessageProcessorWrappingBeanAssembler
    extends DefaultBeanAssembler {
        private final Class wrapperClass;
        private final String propertyNameInWrapper;

        public MessageProcessorWrappingBeanAssembler(PropertyConfiguration beanConfig, BeanDefinitionBuilder bean, PropertyConfiguration targetConfig, BeanDefinition target, Class wrapperClass, String propertyNameInWrapper) {
            super(beanConfig, bean, targetConfig, target);
            this.wrapperClass = wrapperClass;
            this.propertyNameInWrapper = propertyNameInWrapper;
        }

        public void insertBeanInTarget(String oldName) {
            this.assertTargetPresent();
            String newName = MessageProcessorWrappingBeanAssembler.bestGuessName(this.targetConfig, oldName, this.target.getBeanClassName());
            MutablePropertyValues targetProperties = this.target.getPropertyValues();
            PropertyValue pv = targetProperties.getPropertyValue(newName);
            Object oldValue = null == pv ? null : pv.getValue();
            BeanDefinitionBuilder wrapper = BeanDefinitionBuilder.genericBeanDefinition((Class)this.wrapperClass);
            wrapper.addPropertyValue(this.propertyNameInWrapper, (Object)this.bean.getBeanDefinition());
            if (oldValue == null) {
                oldValue = new ManagedList();
                pv = new PropertyValue(newName, oldValue);
                targetProperties.addPropertyValue(pv);
            }
            if (this.targetConfig.isCollection(oldName)) {
                List list = MessageProcessorWrappingBeanAssembler.retrieveList(oldValue);
                list.add(wrapper.getBeanDefinition());
            } else {
                targetProperties.addPropertyValue(newName, (Object)wrapper.getBeanDefinition());
            }
        }
    }

    private static class MessageProcessorWrappingBeanAssemblerFactory
    implements BeanAssemblerFactory {
        private final Class wrapperClass;
        private final String propertyNameInWrapper;

        public MessageProcessorWrappingBeanAssemblerFactory(Class wrapperClass, String propertyNameInWrapper) {
            this.wrapperClass = wrapperClass;
            this.propertyNameInWrapper = propertyNameInWrapper;
        }

        public BeanAssembler newBeanAssembler(PropertyConfiguration beanConfig, BeanDefinitionBuilder bean, PropertyConfiguration targetConfig, BeanDefinition target) {
            return new MessageProcessorWrappingBeanAssembler(beanConfig, bean, targetConfig, target, this.wrapperClass, this.propertyNameInWrapper);
        }
    }

    public static interface WrappingController {
        public boolean shouldWrap(Element var1);
    }
}

