/*
 * Decompiled with CFR 0.152.
 */
package com.zaubersoftware.gnip4j.api.support.logging;

import com.zaubersoftware.gnip4j.api.support.logging.nil.NilLoggerFactory;
import com.zaubersoftware.gnip4j.api.support.logging.slf4j.SLF4JTargetLoggerFactory;
import com.zaubersoftware.gnip4j.api.support.logging.spi.Logger;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;

public final class LoggerFactory {
    private static com.zaubersoftware.gnip4j.api.support.logging.spi.LoggerFactory targetLoggerFactory = LoggerFactory.getLoggerImplementation();

    private LoggerFactory() {
    }

    private static com.zaubersoftware.gnip4j.api.support.logging.spi.LoggerFactory getLoggerImplementation() {
        try {
            boolean hasSlf4 = false;
            Enumeration<URL> resources = LoggerFactory.class.getClassLoader().getResources("org/slf4j/Logger.class");
            while (resources.hasMoreElements()) {
                resources.nextElement();
                hasSlf4 = true;
            }
            targetLoggerFactory = hasSlf4 ? new SLF4JTargetLoggerFactory() : new NilLoggerFactory();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return targetLoggerFactory;
    }

    public static Logger getLogger(Class<?> clazz) {
        return targetLoggerFactory.getLogger(clazz);
    }
}

