/*
 * Decompiled with CFR 0.152.
 */
package com.zaubersoftware.gnip4j.api.support.jmx.sun;

import com.zaubersoftware.gnip4j.api.GnipStream;
import com.zaubersoftware.gnip4j.api.support.jmx.spi.JMXProvider;
import com.zaubersoftware.gnip4j.api.support.jmx.sun.StreamStats;
import com.zaubersoftware.gnip4j.api.support.logging.LoggerFactory;
import com.zaubersoftware.gnip4j.api.support.logging.spi.Logger;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class SunJMXProvider
implements JMXProvider {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public final void registerBean(GnipStream stream, com.zaubersoftware.gnip4j.api.stats.StreamStats streamStats) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName mbeanName = this.getStreamName(stream);
            mbs.registerMBean(new StreamStats(streamStats), mbeanName);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new IllegalArgumentException(e);
        }
        catch (MBeanRegistrationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NotCompliantMBeanException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private ObjectName getStreamName(GnipStream stream) {
        String name = "com.zaubersoftware.gnip4j.streams." + stream.getStreamName() + ":type=StreamStats";
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("bad name", e);
        }
    }

    @Override
    public final void unregister(GnipStream stream) {
        ObjectName name = this.getStreamName(stream);
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(name);
        }
        catch (MBeanRegistrationException e) {
            throw new RuntimeException(e);
        }
        catch (InstanceNotFoundException e) {
            this.logger.warn("Unknown stream: " + name);
        }
    }
}

