/*
 * Decompiled with CFR 0.152.
 */
package com.zaubersoftware.gnip4j.api.support.http;

import com.zaubersoftware.gnip4j.api.GnipAuthentication;
import com.zaubersoftware.gnip4j.api.exception.AuthenticationGnipException;
import com.zaubersoftware.gnip4j.api.exception.TransportGnipException;
import com.zaubersoftware.gnip4j.api.support.base64.Base64PasswordEncoderFactory;
import com.zaubersoftware.gnip4j.api.support.base64.spi.Base64PasswordEncoder;
import com.zaubersoftware.gnip4j.api.support.http.AbstractRemoteResourceProvider;
import com.zaubersoftware.gnip4j.api.support.http.ErrorProvider;
import com.zaubersoftware.gnip4j.api.support.http.Errors;
import com.zaubersoftware.gnip4j.api.support.http.JREReleaseInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.codehaus.jackson.map.ObjectMapper;

public class JRERemoteResourceProvider
extends AbstractRemoteResourceProvider {
    private final GnipAuthentication authentication;
    private final Base64PasswordEncoder encoder = Base64PasswordEncoderFactory.getEncoder();
    private final int connectTimeout = 10000;
    private final int readTimeout = 35000;
    private final ObjectMapper mapper = new ObjectMapper();
    static final ObjectMapper m = new ObjectMapper();

    public JRERemoteResourceProvider(GnipAuthentication authentication) {
        if (authentication == null) {
            throw new IllegalArgumentException("The Gnip authentication cannot be null");
        }
        this.authentication = authentication;
        if (CookieHandler.getDefault() == null) {
            CookieHandler.setDefault(new CookieManager());
        }
    }

    @Override
    public final InputStream getResource(URI uri) throws AuthenticationGnipException, TransportGnipException {
        try {
            URLConnection uc = uri.toURL().openConnection();
            HttpURLConnection huc = null;
            if (uc instanceof HttpURLConnection) {
                huc = (HttpURLConnection)uc;
            }
            uc.setAllowUserInteraction(false);
            uc.setDefaultUseCaches(false);
            uc.setConnectTimeout(10000);
            uc.setReadTimeout(35000);
            uc.setRequestProperty("Accept-Encoding", "gzip, deflate");
            uc.setRequestProperty("User-Agent", "Gnip4j (https://github.com/zaubersoftware/gnip4j/)");
            uc.setRequestProperty("Authorization", "Basic " + this.encoder.encode(this.authentication));
            this.doConfiguration(uc);
            uc.connect();
            if (huc != null) {
                this.validateStatusLine(uri, huc.getResponseCode(), huc.getResponseMessage(), new DefaultErrorProvider(huc));
            }
            InputStream is = JRERemoteResourceProvider.getRealInputStream(uc, uc.getInputStream());
            return new JREReleaseInputStream(uc, is);
        }
        catch (MalformedURLException e) {
            throw new TransportGnipException(e);
        }
        catch (IOException e) {
            throw new TransportGnipException(e);
        }
    }

    static InputStream getRealInputStream(URLConnection uc, InputStream is) throws IOException {
        String encoding = uc.getContentEncoding();
        if (encoding != null && encoding.equalsIgnoreCase("gzip")) {
            is = new GZIPInputStream(is);
        } else if (encoding != null && encoding.equalsIgnoreCase("deflate")) {
            is = new InflaterInputStream(is, new Inflater(true));
        }
        return is;
    }

    @Override
    public final void postResource(URI uri, Object resource) throws AuthenticationGnipException, TransportGnipException {
        OutputStream outStream = null;
        try {
            URLConnection uc = uri.toURL().openConnection();
            HttpURLConnection huc = null;
            if (uc instanceof HttpURLConnection) {
                huc = (HttpURLConnection)uc;
            }
            uc.setAllowUserInteraction(false);
            uc.setDefaultUseCaches(false);
            uc.setConnectTimeout(10000);
            uc.setReadTimeout(35000);
            uc.setDoOutput(true);
            uc.setRequestProperty("Accept-Encoding", "gzip, deflate");
            uc.setRequestProperty("User-Agent", "Gnip4j (https://github.com/zaubersoftware/gnip4j/)");
            uc.setRequestProperty("Authorization", "Basic " + this.encoder.encode(this.authentication));
            uc.setRequestProperty("Content-type", "application/json");
            this.doConfiguration(uc);
            outStream = uc.getOutputStream();
            outStream.write(this.mapper.writeValueAsString(resource).getBytes("utf-8"));
            if (huc != null) {
                this.validateStatusLine(uri, huc.getResponseCode(), huc.getResponseMessage(), new DefaultErrorProvider(huc));
            }
        }
        catch (MalformedURLException e) {
            throw new TransportGnipException(e);
        }
        catch (IOException e) {
            throw new TransportGnipException(e);
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    @Override
    public final void deleteResource(URI uri, Object resource) throws AuthenticationGnipException, TransportGnipException {
        OutputStream outStream = null;
        try {
            URLConnection uc = uri.toURL().openConnection();
            HttpURLConnection huc = null;
            if (uc instanceof HttpURLConnection) {
                huc = (HttpURLConnection)uc;
                huc.setRequestMethod("DELETE");
            }
            uc.setAllowUserInteraction(false);
            uc.setDefaultUseCaches(false);
            uc.setConnectTimeout(10000);
            uc.setReadTimeout(35000);
            uc.setDoOutput(true);
            uc.setRequestProperty("Accept-Encoding", "gzip, deflate");
            uc.setRequestProperty("User-Agent", "Gnip4j (https://github.com/zaubersoftware/gnip4j/)");
            uc.setRequestProperty("Authorization", "Basic " + this.encoder.encode(this.authentication));
            uc.setRequestProperty("Content-type", "application/json");
            this.doConfiguration(uc);
            outStream = uc.getOutputStream();
            outStream.write(new ObjectMapper().writeValueAsString(resource).getBytes());
            if (huc != null) {
                this.validateStatusLine(uri, huc.getResponseCode(), huc.getResponseMessage(), new DefaultErrorProvider(huc));
            }
        }
        catch (MalformedURLException e) {
            throw new TransportGnipException(e);
        }
        catch (IOException e) {
            throw new TransportGnipException(e);
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    protected void doConfiguration(URLConnection uc) {
    }

    static final String toInputStream(InputStream is) {
        try {
            int i;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buff = new byte[4096];
            while ((i = is.read(buff)) >= 0) {
                bos.write(buff, 0, i);
            }
            return new String(bos.toByteArray(), "utf-8");
        }
        catch (IOException e) {
            return "";
        }
    }

    static class DefaultErrorProvider
    implements ErrorProvider {
        private final HttpURLConnection huc;

        public DefaultErrorProvider(HttpURLConnection huc) {
            this.huc = huc;
        }

        @Override
        public String getError() {
            try {
                InputStream is = JRERemoteResourceProvider.getRealInputStream(this.huc, this.huc.getErrorStream());
                if (this.huc.getContentType().startsWith("application/json")) {
                    return ((Errors)m.readValue(is, Errors.class)).getError().getMessage();
                }
                return JRERemoteResourceProvider.toInputStream(is);
            }
            catch (IOException e) {
                return null;
            }
        }
    }
}

