/*
 * Decompiled with CFR 0.152.
 */
package com.zaubersoftware.gnip4j.api.support.http;

import com.zaubersoftware.gnip4j.api.RemoteResourceProvider;
import com.zaubersoftware.gnip4j.api.exception.AuthenticationGnipException;
import com.zaubersoftware.gnip4j.api.exception.TransportGnipException;
import com.zaubersoftware.gnip4j.api.support.http.ErrorProvider;
import java.net.URI;

public abstract class AbstractRemoteResourceProvider
implements RemoteResourceProvider {
    protected static final String USER_AGENT = "Gnip4j (https://github.com/zaubersoftware/gnip4j/)";

    public final void validateStatusLine(URI uri, int statusCode, String reason, ErrorProvider errorProvider) {
        if (statusCode < 200 || statusCode > 299) {
            if (statusCode == 401) {
                throw new AuthenticationGnipException(reason);
            }
            String msg = null;
            if (errorProvider != null) {
                msg = errorProvider.getError();
            }
            if (msg == null) {
                msg = "";
            }
            throw new TransportGnipException(String.format("Connection to %s: Unexpected status code: %s %s %s", uri, statusCode, reason, msg));
        }
    }
}

