/*
 * Decompiled with CFR 0.152.
 */
package com.zaubersoftware.gnip4j.api.model;

import com.zaubersoftware.gnip4j.api.model.Geo;
import com.zaubersoftware.gnip4j.api.model.Geometries;
import com.zaubersoftware.gnip4j.api.model.Point;
import com.zaubersoftware.gnip4j.api.model.Polygon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.deser.StdDeserializer;

public class GeoDeserializer
extends StdDeserializer<Geo> {
    public GeoDeserializer(Class<Geo> clazz) {
        super(clazz);
    }

    public Geo deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode tree = jp.readValueAsTree();
        JsonNode coordinates = tree.findValue("coordinates");
        JsonNode type = tree.findValue("type");
        Geo geo = new Geo();
        geo.setType(type.getTextValue());
        if (Geometries.valueOf(type.getTextValue()) == Geometries.Polygon) {
            geo.setCoordinates(this.createPolygon(coordinates));
        } else {
            geo.setCoordinates(this.createPoint(coordinates));
        }
        return geo;
    }

    private Point createPoint(JsonNode coordinates) throws IOException {
        Point ret = coordinates.isArray() ? new Point(coordinates.get(0).getDoubleValue(), coordinates.get(1).getDoubleValue()) : new Point(coordinates.get("latitude").getDoubleValue(), coordinates.get("longitude").getDoubleValue());
        return ret;
    }

    private Polygon createPolygon(JsonNode coordinates) throws IOException {
        Iterator elements;
        ArrayList<Point> points = new ArrayList<Point>();
        if (coordinates.has("points")) {
            elements = coordinates.get("points").iterator();
        } else {
            JsonNode values = coordinates.get(0);
            elements = values.getElements();
        }
        while (elements.hasNext()) {
            JsonNode next = (JsonNode)elements.next();
            points.add(this.createPoint(next));
        }
        return new Polygon(points);
    }
}

