/*
 * Decompiled with CFR 0.152.
 */
package com.zaubersoftware.gnip4j.api.impl.formats;

import com.zaubersoftware.gnip4j.api.GnipStream;
import com.zaubersoftware.gnip4j.api.StreamNotification;
import com.zaubersoftware.gnip4j.api.impl.formats.AtomFeedParser;
import com.zaubersoftware.gnip4j.api.impl.formats.BaseFeedProcessor;
import com.zaubersoftware.gnip4j.api.model.Activity;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLActivityStreamFeedProcessor
extends BaseFeedProcessor {
    private final Pattern startPattern = Pattern.compile("^[<]entry .*$");
    private final Pattern endPattern = Pattern.compile("^[<][/]entry.*$");
    private final XMLInputFactory factory = XMLInputFactory.newInstance();

    public XMLActivityStreamFeedProcessor(String streamName, ExecutorService activityService, StreamNotification notification, GnipStream stream) {
        super(streamName, activityService, notification, stream);
    }

    @Override
    public final void process(InputStream is) throws IOException, ParseException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
        String s = null;
        StringBuilder sb = new StringBuilder(6144);
        while ((s = reader.readLine()) != null) {
            if (this.startPattern.matcher(s).matches()) {
                if (sb.length() != 0) {
                    sb = new StringBuilder(6144);
                }
                sb.append(s);
                continue;
            }
            if (this.endPattern.matcher(s).matches()) {
                sb.append(s);
                try {
                    this.handle(this.parse(sb.toString()));
                    continue;
                }
                catch (XMLStreamException e) {
                    throw new IllegalArgumentException("parsing activity", e);
                }
            }
            sb.append(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Activity parse(String s) throws XMLStreamException, ParseException {
        XMLStreamReader reader = this.factory.createXMLStreamReader(new StringReader(s));
        AtomFeedParser parser = new AtomFeedParser();
        try {
            Activity activity = parser.process(reader);
            return activity;
        }
        finally {
            reader.close();
        }
    }
}

