/*
 * Decompiled with CFR 0.152.
 */
package com.zaubersoftware.gnip4j.api.impl.formats;

import com.zaubersoftware.gnip4j.api.GnipStream;
import com.zaubersoftware.gnip4j.api.StreamNotification;
import com.zaubersoftware.gnip4j.api.impl.formats.BaseFeedProcessor;
import com.zaubersoftware.gnip4j.api.model.Activity;
import com.zaubersoftware.gnip4j.api.model.Geo;
import com.zaubersoftware.gnip4j.api.model.GeoDeserializer;
import com.zaubersoftware.gnip4j.api.support.logging.LoggerFactory;
import com.zaubersoftware.gnip4j.api.support.logging.spi.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.module.SimpleModule;

public class JsonActivityFeedProcessor
extends BaseFeedProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public static final ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule gnipActivityModule = new SimpleModule("gnip.activity", new Version(1, 0, 0, null));
        gnipActivityModule.addDeserializer(Geo.class, (JsonDeserializer)new GeoDeserializer(Geo.class));
        mapper.registerModule((Module)gnipActivityModule);
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationConfig.Feature.WRITE_NULL_PROPERTIES, false);
        return mapper;
    }

    public JsonActivityFeedProcessor(String streamName, ExecutorService activityService, StreamNotification notification, GnipStream stream) {
        super(streamName, activityService, notification, stream);
    }

    @Override
    public final void process(InputStream is) throws IOException {
        JsonParser parser = JsonActivityFeedProcessor.getObjectMapper().getJsonFactory().createJsonParser(is);
        this.logger.debug("Starting to consume activity stream {} ...", this.streamName);
        while (!Thread.interrupted()) {
            Activity activity = (Activity)parser.readValueAs(Activity.class);
            this.handle(activity);
        }
    }
}

