/*
 * Decompiled with CFR 0.152.
 */
package com.zaubersoftware.gnip4j.api.impl.formats;

import com.zaubersoftware.gnip4j.api.GnipStream;
import com.zaubersoftware.gnip4j.api.StreamNotification;
import com.zaubersoftware.gnip4j.api.impl.formats.FeedProcessor;
import com.zaubersoftware.gnip4j.api.model.Activity;
import com.zaubersoftware.gnip4j.api.support.logging.LoggerFactory;
import com.zaubersoftware.gnip4j.api.support.logging.spi.Logger;
import java.util.concurrent.ExecutorService;

public abstract class BaseFeedProcessor
implements FeedProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String streamName;
    private final ExecutorService activityService;
    private final StreamNotification notification;
    private final GnipStream stream;

    public BaseFeedProcessor(String streamName, ExecutorService activityService, StreamNotification notification, GnipStream stream) {
        if (streamName == null) {
            throw new IllegalArgumentException("streamName is null");
        }
        if (activityService == null) {
            throw new IllegalArgumentException("activityService is null");
        }
        if (notification == null) {
            throw new IllegalArgumentException("notification is null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream is null");
        }
        this.streamName = streamName;
        this.activityService = activityService;
        this.notification = notification;
        this.stream = stream;
    }

    protected final void handle(final Activity activity) {
        if (activity == null) {
            this.logger.warn("Activity parsed from stream {} is null. Should not happen!", this.streamName);
            return;
        }
        if (activity.getBody() == null && activity.getObject() == null) {
            this.logger.warn("{}: Activity with id {} and link {} has a null body", this.streamName, activity.getId(), activity.getLink());
        }
        this.logger.trace("{}: Notifying activity {}", this.streamName, activity.getBody());
        this.activityService.execute(new Runnable(){

            @Override
            public void run() {
                BaseFeedProcessor.this.notification.notify(activity, BaseFeedProcessor.this.stream);
            }
        });
    }
}

