/*
 * Decompiled with CFR 0.152.
 */
package com.zaubersoftware.gnip4j.api.impl.formats;

import com.zaubersoftware.gnip4j.api.impl.ISO8601DateParser;
import com.zaubersoftware.gnip4j.api.model.Activity;
import com.zaubersoftware.gnip4j.api.model.Actor;
import com.zaubersoftware.gnip4j.api.model.Author;
import com.zaubersoftware.gnip4j.api.model.Category;
import com.zaubersoftware.gnip4j.api.model.Generator;
import com.zaubersoftware.gnip4j.api.model.InReplyTo;
import com.zaubersoftware.gnip4j.api.model.Links;
import com.zaubersoftware.gnip4j.api.model.MatchingRules;
import com.zaubersoftware.gnip4j.api.model.Object;
import com.zaubersoftware.gnip4j.api.model.Provider;
import com.zaubersoftware.gnip4j.api.model.Source;
import com.zaubersoftware.gnip4j.api.support.logging.LoggerFactory;
import com.zaubersoftware.gnip4j.api.support.logging.spi.Logger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class AtomFeedParser {
    private static final String ACTIVITY_NS = "http://activitystrea.ms/spec/1.0/";
    private static final QName ACTIVITY_ACTOR = new QName("http://activitystrea.ms/spec/1.0/", "actor");
    private static final QName ACTIVITY_OBJECT_TYPE = new QName("http://activitystrea.ms/spec/1.0/", "object-type");
    private static final QName ACTIVITY_OBJECT = new QName("http://activitystrea.ms/spec/1.0/", "object");
    private static final QName ACTIVITY_VERB = new QName("http://activitystrea.ms/spec/1.0/", "verb");
    private static final String SERVICE_NS = "http://activitystrea.ms/service-provider";
    private static final QName SERVICE_PROVIDER = new QName("http://activitystrea.ms/service-provider", "provider");
    private static final String GNIP_NS = "http://www.gnip.com/schemas/2010";
    private static final QName GNIP_MATCHING_RULES = new QName("http://www.gnip.com/schemas/2010", "matching_rules");
    private static final QName GNIP_MATCHING_RULE = new QName("http://www.gnip.com/schemas/2010", "matching_rule");
    private static final QName GNIP_RULE = new QName("http://www.gnip.com/schemas/2010", "rule");
    private static final QName GNIP_FAVORITE_COUNT = new QName("http://www.gnip.com/schemas/2010", "statistics");
    private static final String THR_NS = "http://purl.org/syndication/thread/1.0";
    private static final QName THR_IN_REPLY_TO = new QName("http://purl.org/syndication/thread/1.0", "in-reply-to");
    private static final String ATOM_NS = "http://www.w3.org/2005/Atom";
    private static final QName ATOM_ENTRY = new QName("http://www.w3.org/2005/Atom", "entry");
    private static final QName ATOM_ID = new QName("http://www.w3.org/2005/Atom", "id");
    private static final QName ATOM_CREATED = new QName("http://www.w3.org/2005/Atom", "created");
    private static final QName ATOM_UPDATED = new QName("http://www.w3.org/2005/Atom", "updated");
    private static final QName ATOM_PUBLISHED = new QName("http://www.w3.org/2005/Atom", "published");
    private static final QName ATOM_NAME = new QName("http://www.w3.org/2005/Atom", "name");
    private static final QName ATOM_URI = new QName("http://www.w3.org/2005/Atom", "uri");
    private static final QName ATOM_ICON = new QName("http://www.w3.org/2005/Atom", "icon");
    private static final QName ATOM_TITLE = new QName("http://www.w3.org/2005/Atom", "title");
    private static final QName ATOM_CATEGORY = new QName("http://www.w3.org/2005/Atom", "category");
    private static final QName ATOM_LINK = new QName("http://www.w3.org/2005/Atom", "link");
    private static final QName ATOM_SOURCE = new QName("http://www.w3.org/2005/Atom", "source");
    private static final QName ATOM_CONTENT = new QName("http://www.w3.org/2005/Atom", "content");
    private static final QName ATOM_SUMMARY = new QName("http://www.w3.org/2005/Atom", "summary");
    private static final QName ATOM_AUTHOR = new QName("http://www.w3.org/2005/Atom", "author");
    private static final QName ATOM_GENERATOR = new QName("http://www.w3.org/2005/Atom", "generator");
    private static final QName ATOM_SUBTITLE = new QName("http://www.w3.org/2005/Atom", "subtitle");
    private Stack<State> state = new Stack();
    private final DatatypeFactory datatypeFactory;
    private static final Set<String> reportedUnhandled = new HashSet<String>();

    public AtomFeedParser() {
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    Activity process(XMLStreamReader reader) throws XMLStreamException, ParseException {
        Activity activity = new Activity();
        this.state.push(new StartState(activity));
        while (reader.hasNext()) {
            State s;
            boolean reprocess = false;
            reader.next();
            while (reprocess = (s = this.state.peek()).process(reader)) {
            }
        }
        while (!this.state.isEmpty()) {
            State s = this.state.pop();
            s.onDone();
        }
        return activity;
    }

    public static String getText(AtomicBoolean ret, XMLStreamReader reader) throws XMLStreamException {
        String s = reader.getElementText();
        ret.set(true);
        return s;
    }

    private static Links parseLink(XMLStreamReader reader) {
        Links link = new Links();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeName(i).getLocalPart();
            if ("rel".equals(name)) {
                link.setRel(reader.getAttributeValue(i));
                continue;
            }
            if ("type".equals(name)) {
                link.setType(reader.getAttributeValue(i));
                continue;
            }
            if (!"href".equals(name)) continue;
            link.setHref(reader.getAttributeValue(i));
        }
        return link;
    }

    private static InReplyTo parseInReplyTo(XMLStreamReader reader) {
        InReplyTo to = new InReplyTo();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeName(i).getLocalPart();
            if ("type".equals(name)) {
                to.setType(reader.getAttributeValue(i));
                continue;
            }
            if (!"href".equals(name)) continue;
            to.setLink(reader.getAttributeValue(i));
        }
        return to;
    }

    private static Generator parseGenerator(AtomicBoolean ret, XMLStreamReader reader) throws XMLStreamException {
        Generator to = new Generator();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeName(i).getLocalPart();
            if (!"uri".equals(name)) continue;
            to.setLink(reader.getAttributeValue(i));
        }
        to.setDisplayName(AtomFeedParser.getText(ret, reader));
        return to;
    }

    class AuthorState
    extends State {
        private final Author author;

        AuthorState() {
            this.author = new Author();
        }

        public Author getAuthor() {
            return this.author;
        }

        @Override
        public boolean doProcess(XMLStreamReader reader) throws XMLStreamException, ParseException {
            AtomicBoolean ret = new AtomicBoolean(false);
            if (reader.isStartElement() && ATOM_NAME.equals(reader.getName())) {
                this.author.setName(AtomFeedParser.getText(ret, reader));
            } else if (reader.isStartElement() && ATOM_URI.equals(reader.getName())) {
                this.author.setUri(AtomFeedParser.getText(ret, reader));
            } else {
                this.onUnhandledEvent(reader);
            }
            return ret.get();
        }
    }

    class SourceState
    extends State {
        protected final Source source;

        SourceState() {
            this.source = new Source();
        }

        @Override
        public boolean doProcess(XMLStreamReader reader) throws XMLStreamException, ParseException {
            AtomicBoolean ret = new AtomicBoolean(false);
            if (reader.isStartElement() && ATOM_LINK.equals(reader.getName())) {
                this.source.getLinks().add(AtomFeedParser.parseLink(reader));
            } else if (reader.isStartElement() && ATOM_TITLE.equals(reader.getName())) {
                this.source.setTitle(AtomFeedParser.getText(ret, reader));
            } else if (reader.isStartElement() && ATOM_UPDATED.equals(reader.getName())) {
                this.source.setUpdated(ISO8601DateParser.parse(AtomFeedParser.getText(ret, reader)));
            } else if (reader.isStartElement() && GNIP_RULE.equals(reader.getName())) {
                MatchingRules rule = new MatchingRules();
                rule.setValue(AtomFeedParser.getText(ret, reader));
                this.source.getGnip().getMatchingRules().add(rule);
            } else {
                this.onUnhandledEvent(reader);
            }
            return ret.get();
        }
    }

    class ServiceProvider
    extends State {
        protected final Provider provider;

        ServiceProvider() {
            this.provider = new Provider();
        }

        @Override
        public boolean doProcess(XMLStreamReader reader) throws XMLStreamException {
            AtomicBoolean ret = new AtomicBoolean(false);
            if (reader.isStartElement() && ATOM_NAME.equals(reader.getName())) {
                this.provider.setDisplayName(AtomFeedParser.getText(ret, reader));
            } else if (reader.isStartElement() && ATOM_URI.equals(reader.getName())) {
                this.provider.setLink(AtomFeedParser.getText(ret, reader));
            } else if (reader.isStartElement() && ATOM_ICON.equals(reader.getName())) {
                this.provider.setIcon(AtomFeedParser.getText(ret, reader));
            } else {
                this.onUnhandledEvent(reader);
            }
            return ret.get();
        }
    }

    class MatchingRulesState
    extends State {
        protected final List<MatchingRules> rules;

        MatchingRulesState() {
            this.rules = new ArrayList<MatchingRules>();
        }

        @Override
        public boolean doProcess(XMLStreamReader reader) throws XMLStreamException {
            AtomicBoolean ret = new AtomicBoolean(false);
            if (reader.isStartElement() && GNIP_MATCHING_RULE.equals(reader.getName())) {
                MatchingRules rule = new MatchingRules();
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    String name = reader.getAttributeName(i).getLocalPart();
                    if (!"tag".equals(name)) continue;
                    rule.setTag(reader.getAttributeValue(i));
                }
                rule.setValue(AtomFeedParser.getText(ret, reader));
                this.rules.add(rule);
            } else {
                this.onUnhandledEvent(reader);
            }
            return ret.get();
        }
    }

    class ActorState
    extends State {
        protected final Actor actor;

        ActorState() {
            this.actor = new Actor();
        }

        @Override
        public boolean doProcess(XMLStreamReader reader) throws XMLStreamException {
            AtomicBoolean ret = new AtomicBoolean(false);
            if (reader.isStartElement() && ACTIVITY_OBJECT_TYPE.equals(reader.getName())) {
                this.actor.setObjectType(AtomFeedParser.getText(ret, reader));
            } else if (reader.isStartElement() && ATOM_LINK.equals(reader.getName())) {
                this.actor.getLinks().add(AtomFeedParser.parseLink(reader));
            } else {
                this.onUnhandledEvent(reader);
            }
            return ret.get();
        }
    }

    private class ActivityState
    extends State {
        private final Activity activity;

        public ActivityState(Activity activity) {
            this.activity = activity;
        }

        private Activity getActivity() {
            return this.activity;
        }

        @Override
        public boolean doProcess(XMLStreamReader reader) throws XMLStreamException, ParseException {
            AtomicBoolean ret = new AtomicBoolean();
            if (reader.isStartElement() && ATOM_ID.equals(reader.getName())) {
                this.getActivity().setId(AtomFeedParser.getText(ret, reader));
            } else if (reader.isStartElement() && ATOM_PUBLISHED.equals(reader.getName())) {
                GregorianCalendar c = new GregorianCalendar();
                c.setTime(ISO8601DateParser.parse(AtomFeedParser.getText(ret, reader)));
                this.getActivity().setPostedTime(AtomFeedParser.this.datatypeFactory.newXMLGregorianCalendar(c));
            } else if (reader.isStartElement() && ATOM_CREATED.equals(reader.getName())) {
                this.getActivity().setCreated(ISO8601DateParser.parse(AtomFeedParser.getText(ret, reader)));
            } else if (reader.isStartElement() && ATOM_UPDATED.equals(reader.getName())) {
                this.getActivity().setUpdated(ISO8601DateParser.parse(AtomFeedParser.getText(ret, reader)));
            } else if (reader.isStartElement() && ATOM_TITLE.equals(reader.getName())) {
                this.getActivity().setTitle(AtomFeedParser.getText(ret, reader));
            } else if (reader.isStartElement() && ATOM_CATEGORY.equals(reader.getName())) {
                Category category = new Category();
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    String name = reader.getAttributeName(i).getLocalPart();
                    if ("term".equals(name)) {
                        category.setTerm(reader.getAttributeValue(i));
                        continue;
                    }
                    if (!"label".equals(name)) continue;
                    category.setLabel(reader.getAttributeValue(i));
                }
                this.getActivity().getCategoriesRules().add(category);
            } else if (reader.isStartElement() && ATOM_LINK.equals(reader.getName())) {
                this.getActivity().getLinks().add(AtomFeedParser.parseLink(reader));
            } else if (reader.isStartElement() && ATOM_SOURCE.equals(reader.getName())) {
                AtomFeedParser.this.state.push(new SourceState(){

                    @Override
                    public void onDone() {
                        ActivityState.this.getActivity().setSource(this.source);
                    }
                });
            } else if (reader.isStartElement() && ATOM_LINK.equals(reader.getName())) {
                this.getActivity().getLinks().add(AtomFeedParser.parseLink(reader));
            } else if (reader.isStartElement() && ACTIVITY_ACTOR.equals(reader.getName())) {
                AtomFeedParser.this.state.push(new ActorState(){

                    @Override
                    public void onDone() {
                        ActivityState.this.getActivity().setActor(this.actor);
                    }
                });
            } else if (reader.isStartElement() && GNIP_MATCHING_RULES.equals(reader.getName())) {
                AtomFeedParser.this.state.push(new MatchingRulesState(){

                    @Override
                    public void onDone() {
                        ActivityState.this.getActivity().getGnip().getMatchingRules().addAll(this.rules);
                    }
                });
            } else if (reader.isStartElement() && GNIP_FAVORITE_COUNT.equals(reader.getName())) {
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    String name = reader.getAttributeName(i).getLocalPart();
                    if (!"favoriteCount".equals(name)) continue;
                    this.getActivity().getGnip().setFavoriteCount(Long.parseLong(reader.getAttributeValue(i)));
                }
            } else if (reader.isStartElement() && ACTIVITY_OBJECT.equals(reader.getName())) {
                final Object o = new Object();
                AtomFeedParser.this.state.push(new ActivityState(o){

                    @Override
                    public void onDone() {
                        ActivityState.this.getActivity().setObject(o);
                    }
                });
            } else if (reader.isStartElement() && SERVICE_PROVIDER.equals(reader.getName())) {
                AtomFeedParser.this.state.push(new ServiceProvider(){

                    @Override
                    public void onDone() {
                        ActivityState.this.getActivity().setProvider(this.provider);
                    }
                });
            } else if (reader.isStartElement() && ACTIVITY_VERB.equals(reader.getName())) {
                this.getActivity().setVerb(AtomFeedParser.getText(ret, reader));
            } else if (reader.isStartElement() && ACTIVITY_OBJECT_TYPE.equals(reader.getName())) {
                this.getActivity().setObjectType(AtomFeedParser.getText(ret, reader));
            } else if (reader.isStartElement() && ATOM_SUMMARY.equals(reader.getName())) {
                this.getActivity().setSummary(AtomFeedParser.getText(ret, reader));
            } else if (reader.isStartElement() && ATOM_AUTHOR.equals(reader.getName())) {
                AtomFeedParser.this.state.push(new AuthorState(){

                    @Override
                    public void onDone() {
                        ActivityState.this.getActivity().setAuthor(this.getAuthor());
                    }
                });
            } else if (reader.isStartElement() && ATOM_CONTENT.equals(reader.getName())) {
                this.getActivity().setContent(AtomFeedParser.getText(ret, reader));
            } else if (reader.isStartElement() && THR_IN_REPLY_TO.equals(reader.getName())) {
                this.getActivity().setInReplyTo(AtomFeedParser.parseInReplyTo(reader));
            } else if (reader.isStartElement() && ATOM_GENERATOR.equals(reader.getName())) {
                this.getActivity().setGenerator(AtomFeedParser.parseGenerator(ret, reader));
            } else if (reader.isStartElement() && ATOM_SUBTITLE.equals(reader.getName())) {
                this.getActivity().setSubtitle(AtomFeedParser.getText(ret, reader));
            } else {
                this.onUnhandledEvent(reader);
            }
            return ret.get();
        }
    }

    class StartState
    extends State {
        private final Activity activity;

        public StartState(Activity activity) {
            this.activity = activity;
        }

        @Override
        public boolean doProcess(XMLStreamReader reader) {
            if (reader.isStartElement() && ATOM_ENTRY.equals(reader.getName())) {
                AtomFeedParser.this.state.push(new ActivityState(this.activity));
            } else {
                this.onUnhandledEvent(reader);
            }
            return false;
        }
    }

    abstract class State {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final ExitStrategy exit = new ExitStrategy();

        State() {
        }

        public final boolean process(XMLStreamReader reader) throws XMLStreamException, ParseException {
            boolean ret = false;
            if (reader.isStartElement()) {
                this.exit.notifyStartElement(reader);
            } else if (reader.isEndElement()) {
                this.exit.notifyEndElement(reader);
            }
            if (this.exit.isDone()) {
                this.onDone();
                AtomFeedParser.this.state.pop();
            } else {
                ret = this.doProcess(reader);
            }
            return ret;
        }

        public abstract boolean doProcess(XMLStreamReader var1) throws XMLStreamException, ParseException;

        public void onDone() {
        }

        protected void onUnhandledEvent(XMLStreamReader reader) {
            if (reader.isStartElement()) {
                String key = this.getClass().getName() + reader.getName().toString();
                if (!reportedUnhandled.contains(key)) {
                    this.logger.warn("The element `{}' is not being handled by the parser in class. You could enhace this situation :)", reader.getName());
                    reportedUnhandled.add(key);
                }
            }
        }
    }

    static final class ExitStrategy {
        private int i = 1;

        ExitStrategy() {
        }

        public void notifyStartElement(XMLStreamReader reader) {
            ++this.i;
        }

        public void notifyEndElement(XMLStreamReader reader) {
            --this.i;
        }

        public boolean isDone() {
            return this.i == 0;
        }
    }
}

