/*
 * Decompiled with CFR 0.152.
 */
package com.zaubersoftware.gnip4j.api.impl;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ISO8601DateParser {
    private static ThreadLocal<DateFormat> normalDf = new ThreadLocal<DateFormat>(){

        @Override
        protected synchronized DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
        }
    };
    private static ThreadLocal<DateFormat> hackDf = new ThreadLocal<DateFormat>(){

        @Override
        protected synchronized DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH-mm-ss");
        }
    };

    public static Date parse(String input) throws ParseException {
        if (input.endsWith("Z")) {
            input = input.replaceAll("(\\.\\d{3})?Z$", "GMT-00:00");
        } else {
            int inset = 6;
            String s0 = input.substring(0, input.length() - 6);
            String s1 = input.substring(input.length() - 6, input.length());
            input = s0 + "GMT" + s1;
        }
        try {
            return normalDf.get().parse(input);
        }
        catch (ParseException e) {
            return hackDf.get().parse(input);
        }
    }
}

