/*
 * Decompiled with CFR 0.152.
 */
package com.zaubersoftware.gnip4j.api.impl;

import com.zaubersoftware.gnip4j.api.UriStrategy;
import java.net.URI;

public final class EnterpriseDataCollectorUriStrategy
implements UriStrategy {
    public static final String STREAM_URI = "https://%s.gnip.com/data_collectors/%s/stream.xml";
    public static final String RULES_URI = "https://%s.gnip.com/data_collectors/%s/rules.json";

    @Override
    public URI createStreamUri(String account, String streamName) {
        if (account == null || account.trim().isEmpty()) {
            throw new IllegalArgumentException("The account cannot be null or empty");
        }
        if (streamName == null || streamName.trim().isEmpty()) {
            throw new IllegalArgumentException("The streamName cannot be null or empty");
        }
        return URI.create(String.format(STREAM_URI, account.trim(), streamName.trim()));
    }

    @Override
    public URI createRulesUri(String account, String streamName) {
        if (account == null || account.trim().isEmpty()) {
            throw new IllegalArgumentException("The account cannot be null or empty");
        }
        if (streamName == null || streamName.trim().isEmpty()) {
            throw new IllegalArgumentException("The streamName cannot be null or empty");
        }
        return URI.create(String.format(RULES_URI, account.trim(), streamName.trim()));
    }
}

