/*
 * Decompiled with CFR 0.152.
 */
package com.zaubersoftware.gnip4j.api.impl;

import com.zaubersoftware.gnip4j.api.UriStrategy;
import java.net.URI;

public final class DefaultUriStrategy
implements UriStrategy {
    public static final String BASE_GNIP_STREAM_URI = "https://stream.gnip.com:443/accounts/%s/publishers/%s/streams/track/%s.json";
    public static final String BASE_GNIP_RULES_URI = "https://api.gnip.com:443/accounts/%s/publishers/%s/streams/track/%s/rules.json";
    private final String publisher;

    public DefaultUriStrategy() {
        this("twitter");
    }

    public DefaultUriStrategy(String publisher) {
        if (publisher == null) {
            throw new IllegalArgumentException("The publisher cannot be null or empty");
        }
        this.publisher = publisher;
    }

    @Override
    public URI createStreamUri(String account, String streamName) {
        if (account == null || account.trim().isEmpty()) {
            throw new IllegalArgumentException("The account cannot be null or empty");
        }
        if (streamName == null || streamName.trim().isEmpty()) {
            throw new IllegalArgumentException("The streamName cannot be null or empty");
        }
        return URI.create(String.format(BASE_GNIP_STREAM_URI, account.trim(), this.publisher.trim(), streamName.trim()));
    }

    @Override
    public URI createRulesUri(String account, String streamName) {
        if (account == null || account.trim().isEmpty()) {
            throw new IllegalArgumentException("The account cannot be null or empty");
        }
        if (streamName == null || streamName.trim().isEmpty()) {
            throw new IllegalArgumentException("The streamName cannot be null or empty");
        }
        return URI.create(String.format(BASE_GNIP_RULES_URI, account.trim(), this.publisher.trim(), streamName.trim()));
    }
}

