/*
 * Decompiled with CFR 0.152.
 */
package com.zaubersoftware.gnip4j.api.impl;

import com.zaubersoftware.gnip4j.api.GnipStream;
import com.zaubersoftware.gnip4j.api.RemoteResourceProvider;
import com.zaubersoftware.gnip4j.api.StreamNotification;
import com.zaubersoftware.gnip4j.api.StreamNotificationAdapter;
import com.zaubersoftware.gnip4j.api.UriStrategy;
import com.zaubersoftware.gnip4j.api.exception.GnipException;
import com.zaubersoftware.gnip4j.api.exception.TransportGnipException;
import com.zaubersoftware.gnip4j.api.impl.AbstractGnipStream;
import com.zaubersoftware.gnip4j.api.impl.formats.BaseFeedProcessor;
import com.zaubersoftware.gnip4j.api.impl.formats.FeedProcessor;
import com.zaubersoftware.gnip4j.api.impl.formats.JsonActivityFeedProcessor;
import com.zaubersoftware.gnip4j.api.impl.formats.XMLActivityStreamFeedProcessor;
import com.zaubersoftware.gnip4j.api.model.Activity;
import com.zaubersoftware.gnip4j.api.stats.DefaultStreamStats;
import com.zaubersoftware.gnip4j.api.stats.ModifiableStreamStats;
import com.zaubersoftware.gnip4j.api.stats.StreamStats;
import com.zaubersoftware.gnip4j.api.stats.StreamStatsInputStream;
import com.zaubersoftware.gnip4j.api.support.logging.LoggerFactory;
import com.zaubersoftware.gnip4j.api.support.logging.spi.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultGnipStream
extends AbstractGnipStream {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String streamName;
    private final URI streamURI;
    private final RemoteResourceProvider client;
    private final ExecutorService activityService;
    private GnipHttpConsumer httpConsumer;
    private Thread httpThread;
    private final ModifiableStreamStats stats = new DefaultStreamStats();
    private StreamNotification notification = new StreamNotificationAdapter(){

        @Override
        public void notify(Activity activity, GnipStream stream) {
            DefaultGnipStream.this.logger.warn("No notification is registed for stream {}", DefaultGnipStream.this.getStreamName());
        }
    };
    private boolean captureStats = true;
    private final AtomicBoolean shuttingDown = new AtomicBoolean(false);

    public DefaultGnipStream(RemoteResourceProvider client, String account, String streamName, ExecutorService activityService, UriStrategy baseUriStrategy) {
        if (client == null) {
            throw new IllegalArgumentException("The HTTP client cannot be null");
        }
        if (account == null || account.trim().length() == 0) {
            throw new IllegalArgumentException("The account cannot be empty");
        }
        if (streamName == null || streamName.trim().length() == 0) {
            throw new IllegalArgumentException("The stream name cannot be empty");
        }
        if (activityService == null) {
            throw new IllegalArgumentException("The activity ExecutorService cannot be null");
        }
        if (baseUriStrategy == null) {
            throw new IllegalArgumentException("The base URI strategy cannot be null");
        }
        this.streamURI = baseUriStrategy.createStreamUri(account, streamName);
        this.client = client;
        this.streamName = streamName;
        this.activityService = activityService;
    }

    @Override
    public final String getStreamName() {
        return this.streamName;
    }

    public final void open(StreamNotification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(this.getStreamName() + " does not support null observers");
        }
        this.notification = notification;
        if (this.httpConsumer != null) {
            throw new IllegalStateException("The stream is open");
        }
        BaseFeedProcessor processor = this.streamURI.getPath().endsWith("xml") ? new XMLActivityStreamFeedProcessor(this.streamName, this.activityService, notification, this) : new JsonActivityFeedProcessor(this.streamName, this.activityService, notification, this);
        this.httpConsumer = new GnipHttpConsumer(this.getStreamInputStream(), processor);
        this.httpThread = new Thread((Runnable)this.httpConsumer, this.streamName + "-consumer-http");
        this.httpThread.start();
    }

    public static boolean waitForTermination(Thread thread) {
        boolean wait = true;
        while (wait && thread.isAlive()) {
            try {
                thread.join();
                wait = false;
            }
            catch (InterruptedException e) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return wait;
    }

    @Override
    protected final void doClose() {
        if (!this.shuttingDown.getAndSet(true)) {
            this.logger.info("Shutting Down " + this.streamName);
            this.httpConsumer.closeInputStream();
            if (this.httpThread != null) {
                this.httpThread.interrupt();
                if (!Thread.currentThread().equals(this.httpThread)) {
                    DefaultGnipStream.waitForTermination(this.httpThread);
                }
            }
            this.activityService.shutdown();
        } else {
            this.logger.info("Already shutting Down " + this.streamName);
        }
    }

    private InputStream getStreamInputStream() {
        InputStream ret = this.client.getResource(this.streamURI);
        if (this.captureStats) {
            ret = new StreamStatsInputStream(this.stats, ret);
        }
        return ret;
    }

    public final boolean isCaptureStats() {
        return this.captureStats;
    }

    public final void setCaptureStats(boolean captureStats) {
        this.captureStats = captureStats;
    }

    @Override
    public final StreamStats getStreamStats() {
        return this.stats;
    }

    private class GnipHttpConsumer
    implements Runnable {
        private static final long MAX_RE_CONNECTION_WAIT_TIME = 300000L;
        private static final long INITIAL_RE_CONNECTION_WAIT_TIME = 250L;
        private final AtomicInteger reConnectionAttempt = new AtomicInteger();
        private long reConnectionWaitTime = 250L;
        private InputStream is;
        private FeedProcessor processor;

        public GnipHttpConsumer(InputStream response, FeedProcessor proccesor) {
            if (response == null) {
                throw new IllegalArgumentException("response is null");
            }
            if (proccesor == null) {
                throw new IllegalArgumentException("processor is null");
            }
            this.is = response;
            this.processor = proccesor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!DefaultGnipStream.this.shuttingDown.get() && !Thread.interrupted()) {
                    try {
                        if (this.is == null) {
                            this.reconnect();
                        }
                        if (this.is == null) continue;
                        this.processor.process(this.is);
                        DefaultGnipStream.this.logger.debug("{}: The activity stream is no longer being consumed.", DefaultGnipStream.this.streamName);
                    }
                    catch (IOException e) {
                        final String msg = "I/O error in channel " + DefaultGnipStream.this.streamName + ": " + e.getLocalizedMessage();
                        if (DefaultGnipStream.this.logger.isWarnEnabled()) {
                            DefaultGnipStream.this.logger.warn(msg, e);
                        }
                        if (DefaultGnipStream.this.shuttingDown.get()) continue;
                        DefaultGnipStream.this.activityService.execute(new Runnable(){

                            @Override
                            public void run() {
                                DefaultGnipStream.this.notification.notifyConnectionError(new TransportGnipException(msg, e));
                            }
                        });
                    }
                    catch (Throwable e) {
                        if (!DefaultGnipStream.this.logger.isWarnEnabled()) continue;
                        DefaultGnipStream.this.logger.warn("Unexpected exception while consuming activity stream " + DefaultGnipStream.this.streamName + ": " + e.getMessage(), e);
                    }
                    finally {
                        this.closeInputStream();
                    }
                }
            }
            finally {
                DefaultGnipStream.this.close();
            }
        }

        void closeInputStream() {
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (IOException e) {
                    throw new TransportGnipException(e);
                }
                this.is = null;
            }
        }

        private void reconnect() {
            DefaultGnipStream.this.stats.incrementNumberOfReconnectionsAttempt();
            DefaultGnipStream.this.logger.debug("{}: Reconnecting...", DefaultGnipStream.this.streamName);
            try {
                final int attempt = this.reConnectionAttempt.incrementAndGet();
                this.reConnectionWaitTime *= 2L;
                this.reConnectionWaitTime = this.reConnectionWaitTime > 300000L ? 300000L : this.reConnectionWaitTime;
                DefaultGnipStream.this.activityService.execute(new Runnable(){

                    @Override
                    public void run() {
                        DefaultGnipStream.this.notification.notifyReConnectionAttempt(attempt, GnipHttpConsumer.this.reConnectionWaitTime);
                    }
                });
                DefaultGnipStream.this.logger.debug("{}: Waiting for {} ms till next re-connection", DefaultGnipStream.this.streamName, this.reConnectionWaitTime);
                try {
                    Thread.sleep(this.reConnectionWaitTime);
                }
                catch (InterruptedException e) {
                    throw new GnipException(DefaultGnipStream.this.streamName + ": waiting for reconnection", e);
                }
                DefaultGnipStream.this.logger.debug("{}: Re-connecting stream with Gnip: {}", DefaultGnipStream.this.streamName, DefaultGnipStream.this.streamURI);
                this.is = DefaultGnipStream.this.getStreamInputStream();
                DefaultGnipStream.this.logger.debug("{}: The re-connection has been successfully established", DefaultGnipStream.this.streamName);
                this.reConnectionAttempt.set(0);
                this.reConnectionWaitTime = 250L;
                DefaultGnipStream.this.stats.incrementNumberOfSuccessfulReconnections();
            }
            catch (Throwable e) {
                DefaultGnipStream.this.logger.error(DefaultGnipStream.this.streamName + ": The re-connection could not be established", e);
                DefaultGnipStream.this.activityService.execute(new Runnable(){

                    @Override
                    public void run() {
                        DefaultGnipStream.this.notification.notifyReConnectionError(e instanceof GnipException ? (GnipException)e : new GnipException(e));
                    }
                });
            }
        }
    }
}

