/*
 * Decompiled with CFR 0.152.
 */
package com.zaubersoftware.gnip4j.api.impl;

import com.zaubersoftware.gnip4j.api.GnipFacade;
import com.zaubersoftware.gnip4j.api.GnipStream;
import com.zaubersoftware.gnip4j.api.RemoteResourceProvider;
import com.zaubersoftware.gnip4j.api.StreamNotification;
import com.zaubersoftware.gnip4j.api.UriStrategy;
import com.zaubersoftware.gnip4j.api.exception.GnipException;
import com.zaubersoftware.gnip4j.api.impl.DefaultGnipStream;
import com.zaubersoftware.gnip4j.api.impl.DefaultUriStrategy;
import com.zaubersoftware.gnip4j.api.impl.formats.JsonActivityFeedProcessor;
import com.zaubersoftware.gnip4j.api.model.Rule;
import com.zaubersoftware.gnip4j.api.model.Rules;
import com.zaubersoftware.gnip4j.api.stats.StreamStats;
import com.zaubersoftware.gnip4j.api.support.jmx.JMXProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;

public class DefaultGnipFacade
implements GnipFacade {
    private static final UriStrategy DEFAULT_BASE_URI_STRATEGY = new DefaultUriStrategy();
    private final RemoteResourceProvider facade;
    private int streamDefaultWorkers = Runtime.getRuntime().availableProcessors();
    private boolean useJMX = true;
    private final UriStrategy baseUriStrategy;

    public DefaultGnipFacade(RemoteResourceProvider facade, UriStrategy baseUriStrategy) {
        if (facade == null) {
            throw new IllegalArgumentException("The HTTP client cannot be null");
        }
        if (baseUriStrategy == null) {
            throw new IllegalArgumentException("The base URI strategy cannot be null");
        }
        this.facade = facade;
        this.baseUriStrategy = baseUriStrategy;
    }

    public DefaultGnipFacade(RemoteResourceProvider facade) {
        this(facade, DEFAULT_BASE_URI_STRATEGY);
    }

    @Override
    public final GnipStream createStream(String account, String streamName, StreamNotification observer) {
        final ExecutorService executor = Executors.newFixedThreadPool(this.streamDefaultWorkers);
        final GnipStream target = this.createStream(account, streamName, observer, executor);
        return new GnipStream(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                try {
                    target.close();
                }
                finally {
                    executor.shutdown();
                }
            }

            @Override
            public void await() throws InterruptedException {
                target.await();
            }

            @Override
            public boolean await(long time, TimeUnit unit) throws InterruptedException {
                return target.await(time, unit);
            }

            @Override
            public final String getStreamName() {
                return target.getStreamName();
            }

            @Override
            public StreamStats getStreamStats() {
                return target.getStreamStats();
            }
        };
    }

    @Override
    public final GnipStream createStream(String account, String streamName, StreamNotification observer, ExecutorService executor) {
        final DefaultGnipStream stream = this.createStream(account, streamName, executor);
        stream.open(observer);
        GnipStream ret = stream;
        if (this.useJMX) {
            ret = new GnipStream(){

                @Override
                public String getStreamName() {
                    return stream.getStreamName();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() {
                    try {
                        stream.close();
                    }
                    finally {
                        JMXProvider.getProvider().unregister(stream);
                    }
                }

                @Override
                public void await() throws InterruptedException {
                    stream.await();
                }

                @Override
                public boolean await(long time, TimeUnit unit) throws InterruptedException {
                    return stream.await(time, unit);
                }

                @Override
                public StreamStats getStreamStats() {
                    return stream.getStreamStats();
                }
            };
            JMXProvider.getProvider().registerBean(stream, stream.getStreamStats());
        }
        return ret;
    }

    public final int getStreamDefaultWorkers() {
        return this.streamDefaultWorkers;
    }

    public final void setStreamDefaultWorkers(int streamDefaultWorkers) {
        if (streamDefaultWorkers < 1) {
            throw new IllegalArgumentException("Must be >= 1");
        }
        this.streamDefaultWorkers = streamDefaultWorkers;
    }

    @Override
    public final Rules getRules(String account, String streamName) {
        try {
            InputStream gnipRestResponseStream = this.facade.getResource(this.baseUriStrategy.createRulesUri(account, streamName));
            JsonParser parser = JsonActivityFeedProcessor.getObjectMapper().getJsonFactory().createJsonParser(gnipRestResponseStream);
            Rules rules = (Rules)parser.readValueAs(Rules.class);
            gnipRestResponseStream.close();
            return rules;
        }
        catch (JsonProcessingException e) {
            throw new GnipException("Unexpected response from Gnip REST API", e);
        }
        catch (IOException e) {
            throw new GnipException(e);
        }
    }

    @Override
    public final void addRule(String account, String streamName, Rule rule) {
        Rules rules = new Rules();
        rules.getRules().add(rule);
        this.addRules(account, streamName, rules);
    }

    @Override
    public final void addRules(String account, String streamName, Rules rules) {
        this.facade.postResource(this.baseUriStrategy.createRulesUri(account, streamName), rules);
    }

    @Override
    public final void deleteRule(String account, String streamName, Rule rule) {
        Rules rules = new Rules();
        rules.getRules().add(rule);
        this.deleteRules(account, streamName, rules);
    }

    @Override
    public final void deleteRules(String account, String streamName, Rules rules) {
        this.facade.deleteResource(this.baseUriStrategy.createRulesUri(account, streamName), rules);
    }

    public final boolean isUseJMX() {
        return this.useJMX;
    }

    public final void setUseJMX(boolean useJMX) {
        this.useJMX = useJMX;
    }

    private DefaultGnipStream createStream(String account, String streamName, ExecutorService executor) {
        return new DefaultGnipStream(this.facade, account, streamName, executor, this.baseUriStrategy);
    }
}

