/*
 * Decompiled with CFR 0.152.
 */
package com.zaubersoftware.gnip4j.api.impl;

import com.zaubersoftware.gnip4j.api.GnipStream;
import com.zaubersoftware.gnip4j.api.support.logging.LoggerFactory;
import com.zaubersoftware.gnip4j.api.support.logging.spi.Logger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractGnipStream
implements GnipStream {
    private final Lock lock = new ReentrantLock();
    private final Condition emptyCondition = this.lock.newCondition();
    private final AtomicBoolean streamClosed = new AtomicBoolean(false);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        if (!this.streamClosed.getAndSet(true)) {
            try {
                this.doClose();
            }
            finally {
                this.lock.lock();
                try {
                    this.emptyCondition.signalAll();
                }
                catch (Throwable t) {
                    this.logger.error("decrementing active jobs. should not happen ", t);
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }

    protected void doClose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void await() throws InterruptedException {
        this.lock.lock();
        try {
            while (!this.streamClosed.get()) {
                this.emptyCondition.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean await(long time, TimeUnit unit) throws InterruptedException {
        boolean ret = false;
        this.lock.lock();
        try {
            this.emptyCondition.await(time, unit);
            ret = this.streamClosed.get();
        }
        finally {
            this.lock.unlock();
        }
        return ret;
    }

    @Override
    public abstract String getStreamName();
}

