/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionHandler;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;

public class WaitPolicy
implements RejectedExecutionHandler {
    private final long time;
    private final TimeUnit timeUnit;

    public WaitPolicy() {
        this(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    public WaitPolicy(long time, TimeUnit timeUnit) {
        this.time = time < 0L ? Long.MAX_VALUE : time;
        this.timeUnit = timeUnit;
    }

    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        try {
            if (e.isShutdown()) {
                throw new RejectedExecutionException("ThreadPoolExecutor is already shut down");
            }
            if (!e.getQueue().offer((Object)r, this.time, this.timeUnit)) {
                String message = String.format("ThreadPoolExecutor did not accept within %1d %2s", this.time, this.timeUnit);
                throw new RejectedExecutionException(message);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RejectedExecutionException((Throwable)ie);
        }
    }
}

