/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.mule.util.StringUtils;

public final class XMLEntityCodec {
    private static final Entities MuleEntities = new Entities();

    protected XMLEntityCodec() {
    }

    public static String encodeString(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        return MuleEntities.escape(str);
    }

    public static String decodeString(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        return MuleEntities.unescape(str);
    }

    public static String entityName(int value) {
        return MuleEntities.map.name(value);
    }

    public static int entityValue(String name) {
        return MuleEntities.map.value(name);
    }

    static {
        MuleEntities.addEntities(Entities.APOS_ARRAY);
        MuleEntities.addEntities(Entities.BASIC_ARRAY);
        MuleEntities.addEntities(Entities.ISO8859_1_ARRAY);
        MuleEntities.addEntities(Entities.HTML40_ARRAY);
    }

    private static class Entities {
        private static final String[][] BASIC_ARRAY = new String[][]{{"quot", "34"}, {"amp", "38"}, {"lt", "60"}, {"gt", "62"}};
        private static final String[][] APOS_ARRAY = new String[][]{{"apos", "39"}};
        static final String[][] ISO8859_1_ARRAY = new String[][]{{"nbsp", "160"}, {"iexcl", "161"}, {"cent", "162"}, {"pound", "163"}, {"curren", "164"}, {"yen", "165"}, {"brvbar", "166"}, {"sect", "167"}, {"uml", "168"}, {"copy", "169"}, {"ordf", "170"}, {"laquo", "171"}, {"not", "172"}, {"shy", "173"}, {"reg", "174"}, {"macr", "175"}, {"deg", "176"}, {"plusmn", "177"}, {"sup2", "178"}, {"sup3", "179"}, {"acute", "180"}, {"micro", "181"}, {"para", "182"}, {"middot", "183"}, {"cedil", "184"}, {"sup1", "185"}, {"ordm", "186"}, {"raquo", "187"}, {"frac14", "188"}, {"frac12", "189"}, {"frac34", "190"}, {"iquest", "191"}, {"Agrave", "192"}, {"Aacute", "193"}, {"Acirc", "194"}, {"Atilde", "195"}, {"Auml", "196"}, {"Aring", "197"}, {"AElig", "198"}, {"Ccedil", "199"}, {"Egrave", "200"}, {"Eacute", "201"}, {"Ecirc", "202"}, {"Euml", "203"}, {"Igrave", "204"}, {"Iacute", "205"}, {"Icirc", "206"}, {"Iuml", "207"}, {"ETH", "208"}, {"Ntilde", "209"}, {"Ograve", "210"}, {"Oacute", "211"}, {"Ocirc", "212"}, {"Otilde", "213"}, {"Ouml", "214"}, {"times", "215"}, {"Oslash", "216"}, {"Ugrave", "217"}, {"Uacute", "218"}, {"Ucirc", "219"}, {"Uuml", "220"}, {"Yacute", "221"}, {"THORN", "222"}, {"szlig", "223"}, {"agrave", "224"}, {"aacute", "225"}, {"acirc", "226"}, {"atilde", "227"}, {"auml", "228"}, {"aring", "229"}, {"aelig", "230"}, {"ccedil", "231"}, {"egrave", "232"}, {"eacute", "233"}, {"ecirc", "234"}, {"euml", "235"}, {"igrave", "236"}, {"iacute", "237"}, {"icirc", "238"}, {"iuml", "239"}, {"eth", "240"}, {"ntilde", "241"}, {"ograve", "242"}, {"oacute", "243"}, {"ocirc", "244"}, {"otilde", "245"}, {"ouml", "246"}, {"divide", "247"}, {"oslash", "248"}, {"ugrave", "249"}, {"uacute", "250"}, {"ucirc", "251"}, {"uuml", "252"}, {"yacute", "253"}, {"thorn", "254"}, {"yuml", "255"}};
        static final String[][] HTML40_ARRAY = new String[][]{{"fnof", "402"}, {"Alpha", "913"}, {"Beta", "914"}, {"Gamma", "915"}, {"Delta", "916"}, {"Epsilon", "917"}, {"Zeta", "918"}, {"Eta", "919"}, {"Theta", "920"}, {"Iota", "921"}, {"Kappa", "922"}, {"Lambda", "923"}, {"Mu", "924"}, {"Nu", "925"}, {"Xi", "926"}, {"Omicron", "927"}, {"Pi", "928"}, {"Rho", "929"}, {"Sigma", "931"}, {"Tau", "932"}, {"Upsilon", "933"}, {"Phi", "934"}, {"Chi", "935"}, {"Psi", "936"}, {"Omega", "937"}, {"alpha", "945"}, {"beta", "946"}, {"gamma", "947"}, {"delta", "948"}, {"epsilon", "949"}, {"zeta", "950"}, {"eta", "951"}, {"theta", "952"}, {"iota", "953"}, {"kappa", "954"}, {"lambda", "955"}, {"mu", "956"}, {"nu", "957"}, {"xi", "958"}, {"omicron", "959"}, {"pi", "960"}, {"rho", "961"}, {"sigmaf", "962"}, {"sigma", "963"}, {"tau", "964"}, {"upsilon", "965"}, {"phi", "966"}, {"chi", "967"}, {"psi", "968"}, {"omega", "969"}, {"thetasym", "977"}, {"upsih", "978"}, {"piv", "982"}, {"bull", "8226"}, {"hellip", "8230"}, {"prime", "8242"}, {"Prime", "8243"}, {"oline", "8254"}, {"frasl", "8260"}, {"weierp", "8472"}, {"image", "8465"}, {"real", "8476"}, {"trade", "8482"}, {"alefsym", "8501"}, {"larr", "8592"}, {"uarr", "8593"}, {"rarr", "8594"}, {"darr", "8595"}, {"harr", "8596"}, {"crarr", "8629"}, {"lArr", "8656"}, {"uArr", "8657"}, {"rArr", "8658"}, {"dArr", "8659"}, {"hArr", "8660"}, {"forall", "8704"}, {"part", "8706"}, {"exist", "8707"}, {"empty", "8709"}, {"nabla", "8711"}, {"isin", "8712"}, {"notin", "8713"}, {"ni", "8715"}, {"prod", "8719"}, {"sum", "8721"}, {"minus", "8722"}, {"lowast", "8727"}, {"radic", "8730"}, {"prop", "8733"}, {"infin", "8734"}, {"ang", "8736"}, {"and", "8743"}, {"or", "8744"}, {"cap", "8745"}, {"cup", "8746"}, {"int", "8747"}, {"there4", "8756"}, {"sim", "8764"}, {"cong", "8773"}, {"asymp", "8776"}, {"ne", "8800"}, {"equiv", "8801"}, {"le", "8804"}, {"ge", "8805"}, {"sub", "8834"}, {"sup", "8835"}, {"sube", "8838"}, {"supe", "8839"}, {"oplus", "8853"}, {"otimes", "8855"}, {"perp", "8869"}, {"sdot", "8901"}, {"lceil", "8968"}, {"rceil", "8969"}, {"lfloor", "8970"}, {"rfloor", "8971"}, {"lang", "9001"}, {"rang", "9002"}, {"loz", "9674"}, {"spades", "9824"}, {"clubs", "9827"}, {"hearts", "9829"}, {"diams", "9830"}, {"OElig", "338"}, {"oelig", "339"}, {"Scaron", "352"}, {"scaron", "353"}, {"Yuml", "376"}, {"circ", "710"}, {"tilde", "732"}, {"ensp", "8194"}, {"emsp", "8195"}, {"thinsp", "8201"}, {"zwnj", "8204"}, {"zwj", "8205"}, {"lrm", "8206"}, {"rlm", "8207"}, {"ndash", "8211"}, {"mdash", "8212"}, {"lsquo", "8216"}, {"rsquo", "8217"}, {"sbquo", "8218"}, {"ldquo", "8220"}, {"rdquo", "8221"}, {"bdquo", "8222"}, {"dagger", "8224"}, {"Dagger", "8225"}, {"permil", "8240"}, {"lsaquo", "8249"}, {"rsaquo", "8250"}, {"euro", "8364"}};
        private EntityMap map = new LookupEntityMap();

        private Entities() {
        }

        public void addEntities(String[][] entityArray) {
            for (int i = 0; i < entityArray.length; ++i) {
                this.addEntity(entityArray[i][0], Integer.parseInt(entityArray[i][1]));
            }
        }

        public void addEntity(String name, int value) {
            this.map.add(name, value);
        }

        public String entityName(int value) {
            return this.map.name(value);
        }

        public int entityValue(String name) {
            return this.map.value(name);
        }

        public String escape(String str) {
            StringBuffer buf = new StringBuffer(str.length() * 2);
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                String entityName = this.entityName(ch);
                if (entityName == null) {
                    if (ch > '\u007f') {
                        buf.append('&');
                        buf.append('#');
                        buf.append((int)ch);
                        buf.append(';');
                        continue;
                    }
                    buf.append(ch);
                    continue;
                }
                buf.append('&');
                buf.append(entityName);
                buf.append(';');
            }
            return buf.toString();
        }

        public void escape(Writer writer, String str) throws IOException {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                String entityName = this.entityName(c);
                if (entityName == null) {
                    if (c > '\u007f') {
                        writer.write("&#");
                        writer.write(Integer.toString(c, 10));
                        writer.write(59);
                        continue;
                    }
                    writer.write(c);
                    continue;
                }
                writer.write(38);
                writer.write(entityName);
                writer.write(59);
            }
        }

        public String unescape(String str) {
            int firstAmp = str.indexOf(38);
            if (firstAmp < 0) {
                return str;
            }
            StringBuffer buf = new StringBuffer(str.length());
            buf.append(str.substring(0, firstAmp));
            for (int i = firstAmp; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (ch == '&') {
                    int entityValue;
                    int semi = str.indexOf(59, i + 1);
                    if (semi == -1) {
                        buf.append(ch);
                        continue;
                    }
                    int amph = str.indexOf(38, i + 1);
                    if (amph != -1 && amph < semi) {
                        buf.append(ch);
                        continue;
                    }
                    String entityName = str.substring(i + 1, semi);
                    if (entityName.length() == 0) {
                        entityValue = -1;
                    } else if (entityName.charAt(0) == '#') {
                        if (entityName.length() == 1) {
                            entityValue = -1;
                        } else {
                            char charAt1 = entityName.charAt(1);
                            try {
                                entityValue = charAt1 == 'x' || charAt1 == 'X' ? Integer.valueOf(entityName.substring(2), 16) : Integer.parseInt(entityName.substring(1));
                                if (entityValue > 65535) {
                                    entityValue = -1;
                                }
                            }
                            catch (NumberFormatException ex) {
                                entityValue = -1;
                            }
                        }
                    } else {
                        entityValue = this.entityValue(entityName);
                    }
                    if (entityValue == -1) {
                        buf.append('&');
                        buf.append(entityName);
                        buf.append(';');
                    } else {
                        buf.append((char)entityValue);
                    }
                    i = semi;
                    continue;
                }
                buf.append(ch);
            }
            return buf.toString();
        }

        public void unescape(Writer writer, String string) throws IOException {
            int firstAmp = string.indexOf(38);
            if (firstAmp < 0) {
                writer.write(string);
                return;
            }
            writer.write(string, 0, firstAmp);
            int len = string.length();
            for (int i = firstAmp; i < len; ++i) {
                char c = string.charAt(i);
                if (c == '&') {
                    int nextIdx = i + 1;
                    int semiColonIdx = string.indexOf(59, nextIdx);
                    if (semiColonIdx == -1) {
                        writer.write(c);
                        continue;
                    }
                    int amphersandIdx = string.indexOf(38, i + 1);
                    if (amphersandIdx != -1 && amphersandIdx < semiColonIdx) {
                        writer.write(c);
                        continue;
                    }
                    String entityContent = string.substring(nextIdx, semiColonIdx);
                    int entityValue = -1;
                    int entityContentLen = entityContent.length();
                    if (entityContentLen > 0) {
                        if (entityContent.charAt(0) == '#') {
                            if (entityContentLen > 1) {
                                char isHexChar = entityContent.charAt(1);
                                try {
                                    switch (isHexChar) {
                                        case 'X': 
                                        case 'x': {
                                            entityValue = Integer.parseInt(entityContent.substring(2), 16);
                                            break;
                                        }
                                        default: {
                                            entityValue = Integer.parseInt(entityContent.substring(1), 10);
                                        }
                                    }
                                    if (entityValue > 65535) {
                                        entityValue = -1;
                                    }
                                }
                                catch (NumberFormatException e) {
                                    entityValue = -1;
                                }
                            }
                        } else {
                            entityValue = this.entityValue(entityContent);
                        }
                    }
                    if (entityValue == -1) {
                        writer.write(38);
                        writer.write(entityContent);
                        writer.write(59);
                    } else {
                        writer.write(entityValue);
                    }
                    i = semiColonIdx;
                    continue;
                }
                writer.write(c);
            }
        }

        private static class IntHashMap {
            private transient Entry[] table;
            private transient int count;
            private int threshold;
            private float loadFactor;

            public IntHashMap() {
                this(20, 0.75f);
            }

            public IntHashMap(int initialCapacity) {
                this(initialCapacity, 0.75f);
            }

            public IntHashMap(int initialCapacity, float loadFactor) {
                if (initialCapacity < 0) {
                    throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
                }
                if (loadFactor <= 0.0f) {
                    throw new IllegalArgumentException("Illegal Load: " + loadFactor);
                }
                if (initialCapacity == 0) {
                    initialCapacity = 1;
                }
                this.loadFactor = loadFactor;
                this.table = new Entry[initialCapacity];
                this.threshold = (int)((float)initialCapacity * loadFactor);
            }

            public int size() {
                return this.count;
            }

            public boolean isEmpty() {
                return this.count == 0;
            }

            public boolean contains(Object value) {
                if (value == null) {
                    throw new IllegalArgumentException("parameter value may not be null");
                }
                Entry[] tab = this.table;
                int i = tab.length;
                while (i-- > 0) {
                    Entry e = tab[i];
                    while (e != null) {
                        if (e.value.equals(value)) {
                            return true;
                        }
                        e = e.next;
                    }
                }
                return false;
            }

            public boolean containsValue(Object value) {
                return this.contains(value);
            }

            public boolean containsKey(int key) {
                Entry[] tab = this.table;
                int hash = key;
                int index = (hash & Integer.MAX_VALUE) % tab.length;
                Entry e = tab[index];
                while (e != null) {
                    if (e.hash == hash) {
                        return true;
                    }
                    e = e.next;
                }
                return false;
            }

            public Object get(int key) {
                Entry[] tab = this.table;
                int hash = key;
                int index = (hash & Integer.MAX_VALUE) % tab.length;
                Entry e = tab[index];
                while (e != null) {
                    if (e.hash == hash) {
                        return e.value;
                    }
                    e = e.next;
                }
                return null;
            }

            protected void rehash() {
                int oldCapacity = this.table.length;
                Entry[] oldMap = this.table;
                int newCapacity = oldCapacity * 2 + 1;
                Entry[] newMap = new Entry[newCapacity];
                this.threshold = (int)((float)newCapacity * this.loadFactor);
                this.table = newMap;
                int i = oldCapacity;
                while (i-- > 0) {
                    Entry old = oldMap[i];
                    while (old != null) {
                        Entry e = old;
                        old = old.next;
                        int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                        e.next = newMap[index];
                        newMap[index] = e;
                    }
                }
            }

            public Object put(int key, Object value) {
                Entry[] tab = this.table;
                int hash = key;
                int index = (hash & Integer.MAX_VALUE) % tab.length;
                Entry e = tab[index];
                while (e != null) {
                    if (e.hash == hash) {
                        Object old = e.value;
                        e.value = value;
                        return old;
                    }
                    e = e.next;
                }
                if (this.count >= this.threshold) {
                    this.rehash();
                    tab = this.table;
                    index = (hash & Integer.MAX_VALUE) % tab.length;
                }
                tab[index] = e = new Entry(hash, key, value, tab[index]);
                ++this.count;
                return null;
            }

            public Object remove(int key) {
                Entry[] tab = this.table;
                int hash = key;
                int index = (hash & Integer.MAX_VALUE) % tab.length;
                Entry e = tab[index];
                Entry prev = null;
                while (e != null) {
                    if (e.hash == hash) {
                        if (prev != null) {
                            prev.next = e.next;
                        } else {
                            tab[index] = e.next;
                        }
                        --this.count;
                        Object oldValue = e.value;
                        e.value = null;
                        return oldValue;
                    }
                    prev = e;
                    e = e.next;
                }
                return null;
            }

            public synchronized void clear() {
                Entry[] tab = this.table;
                int index = tab.length;
                while (--index >= 0) {
                    tab[index] = null;
                }
                this.count = 0;
            }

            private static class Entry {
                int hash;
                int key;
                Object value;
                Entry next;

                protected Entry(int hash, int key, Object value, Entry next) {
                    this.hash = hash;
                    this.key = key;
                    this.value = value;
                    this.next = next;
                }
            }
        }

        private static class LookupEntityMap
        extends PrimitiveEntityMap {
            private static final int LOOKUP_TABLE_SIZE = 256;
            private String[] lookupTable;

            private LookupEntityMap() {
            }

            public String name(int value) {
                if (value < 256) {
                    return this.lookupTable()[value];
                }
                return super.name(value);
            }

            private String[] lookupTable() {
                if (this.lookupTable == null) {
                    this.createLookupTable();
                }
                return this.lookupTable;
            }

            private void createLookupTable() {
                this.lookupTable = new String[256];
                for (int i = 0; i < 256; ++i) {
                    this.lookupTable[i] = super.name(i);
                }
            }
        }

        private static class PrimitiveEntityMap
        implements EntityMap {
            private Map mapNameToValue = new HashMap();
            private IntHashMap mapValueToName = new IntHashMap();

            private PrimitiveEntityMap() {
            }

            public void add(String name, int value) {
                this.mapNameToValue.put(name, new Integer(value));
                this.mapValueToName.put(value, name);
            }

            public String name(int value) {
                return (String)this.mapValueToName.get(value);
            }

            public int value(String name) {
                Object value = this.mapNameToValue.get(name);
                if (value == null) {
                    return -1;
                }
                return (Integer)value;
            }
        }

        private static interface EntityMap {
            public void add(String var1, int var2);

            public String name(int var1);

            public int value(String var1);
        }
    }
}

