/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.util.StreamCloser;
import org.mule.api.util.StreamCloserService;
import org.xml.sax.InputSource;

public class DefaultStreamCloserService
implements StreamCloserService {
    private static final Log log = LogFactory.getLog(DefaultStreamCloserService.class);
    private MuleContext muleContext;
    private StreamCloser coreStreamTypesCloser = new CoreStreamTypesCloser();

    public void closeStream(Object stream) {
        try {
            if (this.coreStreamTypesCloser.canClose(stream.getClass())) {
                this.coreStreamTypesCloser.close(stream);
            } else {
                for (StreamCloser closer : this.muleContext.getRegistry().lookupObjects(StreamCloser.class)) {
                    if (closer.canClose(stream.getClass())) {
                        closer.close(stream);
                        continue;
                    }
                    log.debug((Object)("Unable to find an StreamCloser for the stream type: " + stream.getClass() + ", the stream: " + stream + " will not be closed."));
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)("Exception closing stream: " + stream), (Throwable)e);
        }
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    static class CoreStreamTypesCloser
    implements StreamCloser {
        CoreStreamTypesCloser() {
        }

        public boolean canClose(Class streamType) {
            return InputStream.class.isAssignableFrom(streamType) || InputSource.class.isAssignableFrom(streamType) || StreamSource.class.isAssignableFrom(streamType) || SAXSource.class.isAssignableFrom(streamType) && !streamType.getName().endsWith("StaxSource");
        }

        public void close(Object stream) throws IOException {
            if (stream instanceof InputStream) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {}
            } else if (stream instanceof InputSource) {
                this.closeInputSourceStream((InputSource)stream);
            } else if (stream instanceof SAXSource) {
                this.closeInputSourceStream(((SAXSource)stream).getInputSource());
            } else if (stream instanceof StreamSource) {
                try {
                    ((StreamSource)stream).getInputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void closeInputSourceStream(InputSource payload) throws IOException {
            if (payload.getByteStream() != null) {
                payload.getByteStream().close();
            } else if (payload.getCharacterStream() != null) {
                payload.getCharacterStream().close();
            }
        }
    }
}

